
#ifndef INCLUDED_protocols_fast_sc_mover_SimpleInteractionGraph_HH
#define INCLUDED_protocols_fast_sc_mover_SimpleInteractionGraph_HH

#include <core/graph/Graph.hh>
#include <core/scoring/ScoreFunction.hh>

#include <core/conformation/Residue.hh>
#include <core/pose/Pose.hh>

namespace protocols{
namespace fast_sc_mover{

using namespace core;
using namespace core::scoring;
using namespace graph;

class SimpleNode : public graph::Node {

public:

	//  SimpleNode::SimpleNode();
	SimpleNode( Graph * owner, core::Size resnum );
	virtual ~SimpleNode();

	virtual  void copy_from( Node const * ) {};

	virtual  void print() const {};

	virtual  platform::Size count_static_memory() const {return 1;};
	virtual  platform::Size count_dynamic_memory() const {return 1;};

	core::Real
	one_body_energy();

	core::Real
	proposed_one_body_energy();

	core::Real
	current_one_body_energy();

	bool
	moved();
	//required functions to override

	void
	commit_change();

	void
	reject_change();

	void
	set_current( core::conformation::ResidueOP res);

	void
	set_alternate( core::conformation::ResidueOP res);

	core::conformation::ResidueOP
	get_current();

	core::conformation::ResidueOP
	get_alternate();

private:

	void
	update_current_one_body_energy();

	void
	update_alternate_one_body_energy();

	void
	initialize();

	bool moved_;
	core::Size resnum_;
	core::Real current_one_body_energy_;
	core::Real alternate_one_body_energy_;

	core::conformation::ResidueOP current_residue_;
	core::conformation::ResidueOP alternate_residue_;

}; //SimpleNode


class SimpleEdge : public graph::Edge {

public:

	SimpleEdge( Graph* owner );
	SimpleEdge( Graph* owner, core::Size res1, core::Size res2 );
	virtual ~SimpleEdge();

	virtual  void copy_from( Edge const * ) {};

	virtual  platform::Size count_static_memory() const {return 1;};
	virtual  platform::Size count_dynamic_memory() const {return 1;};

	void
	compute_energy( bool use_current_node1, bool use_current_node2 );

	core::Real
	get_current_energy();

	core::Real
	get_proposed_energy();

	void
	update_current_energy();

	void
	update_proposed_energy();

	void
	commit_change();

	//required functions to override

	/**
	core::Real curr_scsc_E_;
	core::Real curr_bbsc_E_;
	core::Real curr_scbb_E_;

	core::Real alt_scsc_E_;
	core::Real alt_bbsc_E_;
	core::Real alt_scbb_E_;
	**/

	core::Real current_energy_;
	core::Real proposed_energy_;

private:

}; //SimpleEdge


class SimpleInteractionGraph : public graph::Graph {

public:

	SimpleInteractionGraph();
	virtual ~SimpleInteractionGraph();

	void set_scorefunction( ScoreFunction const & sfxn );

	ScoreFunction const &
	scorefunction() const {
	  return *sfxn_;
	};

	core::pose::Pose const &
	pose() const {
		return *pose_;
	}

	void initialize(core::pose::Pose const & pose);

	void commit_change( core::Size node_id);

	void reject_change( core::Size node_id );

	//returns delta-energy
	core::Real consider_substitution( core::Size node_id, core::conformation::ResidueOP new_state );


	core::Real total_energy();

	//required functions to override

  virtual  platform::Size count_static_memory() const {return 0;};
  virtual  platform::Size count_dynamic_memory() const {return 0;};

  virtual void delete_edge( Edge * ) {};

  virtual Node* create_new_node( platform::Size node_index );
  virtual Edge* create_new_edge( platform::Size index1, platform::Size index2 );

  //virtual Edge* create_new_edge( Edge * example_edge );

private:

	ScoreFunctionOP sfxn_;
	core::pose::PoseCOP pose_;
	core::Real accumulated_ediff_; //since data stored in energies
  //object, need to subtract out diffs

}; //SimpleInteractionGraph



} //namespace fast_sc_mover
} //namespace protocols

#endif
