// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file PDDFScoreFilter.cc
/// @brief runs reject or accept filters on pose
/// @detailed
///	  Contains currently: PDDFScoreFilter
///
///
/// @author Dominik Gront

// Unit Headers
#include <protocols/filters/PDDFScoreFilter.hh>

// Project Headers
#include <core/pose/Pose.hh>
#include <core/types.hh>

#include <core/options/option.hh>
#include <core/options/keys/filters.OptionKeys.gen.hh>

// Utility headers
#include <core/util/Tracer.hh>



//// C++ headers
static core::util::Tracer tr("protocols.filters.PDDFScoreFilter");

namespace protocols {
namespace filters {

PDDFScoreFilter::PDDFScoreFilter() {
		using namespace core::options;
		using namespace core::options::OptionKeys;

    score_ = new core::scoring::saxs::PDDFEnergy();
    cutoff_ = core::options::option[ core::options::OptionKeys::filters::set_pddf_filter ]();
    score_value_ = cutoff_+1;
}


bool PDDFScoreFilter::apply( core::pose::Pose const & pose ) const {


	score_value_ = score_->evaluate_pddf_energy( pose );
	if ( score_value_ > cutoff_ )
		return false;
	return true;
}

} // filters
} // protocols
