// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// Copyright in the Rosetta software belongs to the developers and their institutions.
// For more information, see www.rosettacommons.org.

/// @file ./src/protocols/src/fldsgn/topology/util.cc
/// @brief
/// @author Nobuyasu Koga ( nobuyasu@u.washington.edu )

#ifndef INCLUDED_protocols_fldsgn_topology_HelixPairing_HH
#define INCLUDED_protocols_fldsgn_topology_HelixPairing_HH

// unit header
#include <protocols/fldsgn/topology/StrandPairing.fwd.hh>
#include <protocols/fldsgn/topology/SS_Info2.fwd.hh>
#include <core/scoring/dssp/Dssp.hh>

namespace protocols {
namespace fldsgn {
namespace topology {

/// @brief convert StrandParingSet of dssp to fldsgn::topology::StrandPairingSet
protocols::fldsgn::topology::StrandPairingSet
calc_strand_pairing_set(
  core::pose::Pose const & pose,
	protocols::fldsgn::topology::SS_Info2_OP const & ssinfo,
	core::Size minimum_pair_length = 2
 );


} // namespace topology
} // namespace fldsgn
} // namespace protocols

#endif
