// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Nobuyasu Koga

#ifndef INCLUDED_protocols_flxbb_DesignLayerOperation_HH
#define INCLUDED_protocols_flxbb_DesignLayerOperation_HH

// Unit Headers
#include <core/pack/task/operation/TaskOperation.hh>
#include <protocols/flxbb/DesignLayerOperation.fwd.hh>

// Project Headers
// AUTO-REMOVED #include <core/pose/Pose.hh>
#include <core/pack/task/PackerTask.fwd.hh>

//Auto Headers
#include <core/types.hh>
#include <iostream>


// Utility Headers

using namespace core::pack::task;

namespace protocols{
namespace flxbb{

class DesignLayerOperation : public core::pack::task::operation::TaskOperation {
public:

	typedef core::pack::task::operation::TaskOperation TaskOperation;
	typedef core::pack::task::operation::TaskOperationOP TaskOperationOP;
	typedef TaskOperation parent;

public:


	DesignLayerOperation( bool dsgn_core, bool dsgn_boundary, bool dsgn_surface );
	virtual ~DesignLayerOperation();

	virtual TaskOperationOP clone() const;
	virtual void apply( core::pose::Pose const &, core::pack::task::PackerTask & ) const;

	void set_exclude_ala(){
		exclude_ala_ = true;
	}

	void set_exclude_met(){
		exclude_met_ = true;
	}

	void use_original_seq(){
		use_original_ = true;
	}


private:

	bool dsgn_core_, dsgn_boundary_, dsgn_surface_;
	bool exclude_ala_;
	bool exclude_met_;
	bool use_original_;

	core::Real pore_radius_;
	core::Real burial_;
	core::Real surface_;

};

}
}
#endif
