// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/forge/remodel/RemodelEnzdesCstModule.hh
///
/// @brief this file handles merging constraint defined by enzdes type cstfile
/// @brief and blueprint definition of positions and add them to the pose
/// @author Possu Huang, possu@u.washington.edu, Jan 2010

#include <protocols/forge/remodel/RemodelEnzdesCstModule.hh>
#include <core/util/Tracer.hh>
#include <core/options/keys/constraints.OptionKeys.gen.hh>
#include <core/options/option.hh>
#include <core/options/keys/enzdes.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>
#include <core/chemical/ChemicalManager.hh>
#include <utility/vector1.hh>
#include <core/scoring/ScoreFunction.hh>
#include <protocols/toolbox/match_enzdes_util/EnzConstraintParameters.hh>
#include <protocols/toolbox/match_enzdes_util/EnzCstTemplateRes.hh>
#include <protocols/toolbox/match_enzdes_util/EnzdesCstCache.hh>
#include <protocols/enzdes/EnzdesCacheableObserver.hh>

namespace protocols{
namespace forge{
namespace remodel{

static core::util::Tracer TR("protocols.forge.remodel.RemodelEnzdesCstModule");

RemodelEnzdesCstModule::RemodelEnzdesCstModule(RemodelData external_data) : protocols::toolbox::match_enzdes_util::EnzConstraintIO(core::chemical::ChemicalManager::get_instance()->residue_type_set( core::chemical::FA_STANDARD )){
  read_enzyme_cstfile( core::options::option[core::options::OptionKeys::enzdes::cstfile]);
	scorefxn_ = core::scoring::ScoreFunctionFactory::create_score_function("remodel_cen");
	remodel_data_ = external_data;

}

RemodelEnzdesCstModule::~RemodelEnzdesCstModule(){}

void
RemodelEnzdesCstModule::apply(core::pose::Pose & pose)
{
	using namespace protocols::toolbox::match_enzdes_util;

  //set up constraints (read cstfile, do mapping, etc, then add to pose)
  if( core::options::option[core::options::OptionKeys::enzdes::cstfile].user() ){
    enable_constraint_scoreterms(scorefxn_);

		//tmp hack -- from florian for cstcashe observer initialization
		EnzdesCstCacheOP cst_cache = protocols::enzdes::get_enzdes_observer( pose )->cst_cache();
	using namespace protocols::enzdes;
		if( !cst_cache ) {
			get_enzdes_observer( pose )->set_cst_cache( new EnzdesCstCache( this, cst_pairs_.size() ) );
			cst_cache = get_enzdes_observer( pose )->cst_cache();
		}
		//tmp hack over

		blueprint_cst_definition(pose);

		for (core::Size block = 1 ; block <= cstblocksize_; ++block){
			add_constraints_to_pose_for_block_without_clearing_and_header_processing(pose, scorefxn_, block);
		}
   // (*scorefxn_)( pose );
  }

}

void
RemodelEnzdesCstModule::enable_constraint_scoreterms(core::scoring::ScoreFunctionOP scorefxn){
	TR << "turning on constraint weights" << std::endl;
  scorefxn->set_weight(core::scoring::coordinate_constraint, 1.0 );
  scorefxn->set_weight(core::scoring::atom_pair_constraint, 1.0 );
  scorefxn->set_weight(core::scoring::angle_constraint, 1.0 );
  scorefxn->set_weight(core::scoring::dihedral_constraint, 1.0 );
  scorefxn->set_weight(core::scoring::res_type_constraint, 1.0);

}


void
RemodelEnzdesCstModule::blueprint_cst_definition(core::pose::Pose & pose ){

	using namespace protocols::enzdes;

	utility::vector1<core::Size> cstblock;
	utility::vector1<std::string> role;
	utility::vector1<core::Size> position;


	for (core::Size i = 0, ie = remodel_data_.blueprint.size(); i < ie ; i++){
		if (remodel_data_.blueprint[i].has_constraints){
			for (std::vector<std::string>::iterator it = remodel_data_.blueprint[i].constraint_definition.begin(), end = remodel_data_.blueprint[i].constraint_definition.end(); it != end; it++){
			//casting, sort of....
			core::Size found_start = (*it).find_first_of("0123456789");
			core::Size found_end = (*it).find_last_of("0123456789");
			std::string buffer((*it).substr(found_start,found_end-found_start+1));
			//TR << "buffer number: " << buffer << std::endl;
			std::istringstream bufferstream(buffer);
			core::Size temp;
			bufferstream >> temp;
			cstblock.push_back(temp);

			core::Size bufferLength = (*it).length();

			role.push_back((*it).substr(bufferLength-1,1));
			position.push_back(remodel_data_.blueprint[i].index);
			}
		}
	}
TR<< "cstblock.size = " << cstblock.size() << std::endl;
TR<< "cst_pair_.size = " << cst_pairs_.size() << std::endl;

	runtime_assert ( cstblock.size()/2 == cst_pairs_.size());
	cstblocksize_ = cstblock.size()/2;


	for (core::Size i = 1; i <= cstblock.size(); ++i){
		if (role[i] == "A"){
		TR<< "adding constraint to " << position[i]  << " in " << cstblock[i] << std::endl;
			cst_pairs_[cstblock[i]]->nonconst_resA()->set_external_position(position[i]);
			cst_pairs_[cstblock[i]]->nonconst_resA()->find_in_pose_if_missing_from_header( pose );
		//	cst_cache->param_cache( cstblock[i] )->template_res_cache( 1 )->add_position_in_pose( position[i] );//new
		} else if (role[i] == "B"){
		TR<< "adding constraint to " << position[i] << " in " << cstblock[i] << std::endl;
			cst_pairs_[cstblock[i]]->nonconst_resB()->set_external_position(position[i]);
			cst_pairs_[cstblock[i]]->nonconst_resB()->find_in_pose_if_missing_from_header( pose );
		//	cst_cache->param_cache( cstblock[i] )->template_res_cache( 2 )->add_position_in_pose( position[i] );//new
		} else {
			TR << "mistake in merging blueprint cst and cst_pairs data" << std::endl;
		}
	}
}

} //namespace protocols
} //namespace forge
} //namespace remodel


