// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_MinimizeBackbone_HH
#define INCLUDED_protocols_ligand_docking_MinimizeBackbone_HH

// Unit Headers
#include <protocols/ligand_docking/MinimizeBackbone.fwd.hh>
#include <protocols/ligand_docking/ligand_options/Interface.fwd.hh>
#include <protocols/ligand_docking/InterfaceBuilder.fwd.hh>

// Package Headers
#include <core/kinematics/FoldTree.hh> // REWORK THIS HEADER SO THAT THIS INCLUDE IS UNNECESSARY
// cannot use .fwd above because of FoldTree::iterator use here
#include <core/kinematics/Edge.fwd.hh>

//// Project Headers
#include <protocols/moves/Mover.hh>

//// Scripter Headers
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>

//Auto Headers
#include <protocols/loops/Loop.fwd.hh>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {

struct LigandArea{

	LigandArea(char chain, core::Real angstroms):
		chain_(chain),
		angstroms_(angstroms)
	{};
	bool operator==(char chain){
		return chain_ == chain;
	};

	char chain_; // ligand around which to minimize backbone
	core::Real angstroms_;// size of one standard deviation of motion for restraints on C-alphas
};

///@brief
class MinimizeBackbone : public protocols::moves::Mover
{
public:
	MinimizeBackbone();
	virtual ~MinimizeBackbone();
	MinimizeBackbone(MinimizeBackbone const & that);

	virtual void apply( core::pose::Pose & pose );

	virtual protocols::moves::MoverOP clone() const;
	virtual protocols::moves::MoverOP fresh_instance() const;
	virtual std::string get_name() const;

	void parse_my_tag(
		utility::Tag::TagPtr const tag,
		protocols::moves::DataMap &,
		protocols::filters::Filters_map const &,
		protocols::moves::Movers_map const &,
		core::pose::Pose const &
	);

	utility::vector1<LigandArea>
	get_ligand_areas();

private:
	// map of ligand chains to minimize backbone around and how much minimization around each chain
	// Real is the Size of one standard deviation.  For restraints placed on C-alphas
	utility::vector1<LigandArea> ligand_areas_;
	InterfaceBuilderOP interface_builder_;

	void reorder_foldtree_around_mobile_regions(
		ligand_options::Interface const & interface,
		core::pose::Pose & pose
	);

	core::kinematics::FoldTreeOP
	create_fold_tree_with_ligand_jumps_from_attach_pts(
		core::kinematics::FoldTree const &,
		ligand_options::Interface const & interface,
		core::pose::Pose & pose
	);

	core::kinematics::FoldTreeOP
	create_fold_tree_with_cutpoints(
		core::kinematics::FoldTree const & f,
		ligand_options::Interface const & interface,
		core::pose::Pose & pose
	);

	utility::vector1< protocols::loops::Loop >
	add_cut_points(
		core::kinematics::Edge const & edge,
		ligand_options::Interface const & interface,
		core::pose::Pose & pose
	);

	std::map<core::Size, core::Size> find_attach_pts(
		const ligand_options::Interface interface,
		core::pose::Pose const & pose
	) const;

	void
	restrain_protein_Calphas(
		ligand_options::Interface const & interface,
		core::pose::Pose & pose
	);

};

void restrict_to_protein_residues(
	ligand_options::Interface & interface,
	core::pose::Pose const & pose
);

void reorder_with_first_non_mobile_as_root(
	core::kinematics::FoldTree & f,
	const ligand_options::Interface & interface,
	core::pose::Pose & pose
);

core::Size find_attach_pt(
	core::Size const jump_id,
	ligand_options::Interface const interface,
	core::pose::Pose const & pose
);

core::Size
find_peptide_attach_pt(
	core::kinematics::FoldTree::const_iterator const e,
	std::map<core::Size, core::Size > const jump_to_attach
);


} //namespace ligand_docking
} //namespace protocols

#endif
