// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @brief LoopRelaxMover.hh
/// @author James Thompson

#ifndef INCLUDED_protocols_loops_LoopRelaxMover_HH
#define INCLUDED_protocols_loops_LoopRelaxMover_HH

#include <core/types.hh>
#include <core/fragment/FragSet.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

#include <protocols/moves/Mover.hh>
#include <protocols/loops/Loops.hh>
#include <protocols/loops/LoopRelaxMover.fwd.hh>

#include <string>

namespace protocols {
namespace loops {

class LoopRelaxMover : public moves::Mover {

public:

	// constructor
	LoopRelaxMover();

	LoopRelaxMover(
		std::string const & remodel,
		std::string const & intermedrelax,
		std::string const & refine,
		std::string const & relax,
		loops::Loops loops
	);

	//destructor
	~LoopRelaxMover();

	void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;

	// getters and setters
	void scorefxns( core::scoring::ScoreFunctionOP cen_scorefxn, core::scoring::ScoreFunctionOP fa_scorefxn );
	void fa_scorefxn( core::scoring::ScoreFunctionOP fa_scorefxn );
	void cen_scorefxn( core::scoring::ScoreFunctionOP cen_scorefxn );

	void cmd_line_csts( bool setting ) {
		cmd_line_csts_ = setting;
	}

	void copy_sidechains( bool setting ) {
		copy_sidechains_ = setting;
	}

	void rebuild_filter( core::Real setting ) {
		rebuild_filter_ = setting;
	}

	void n_rebuild_tries( core::Size setting ) {
		n_rebuild_tries_ = setting;
	}

	void remodel( std::string val ) {
		remodel_ = val;
	}

	void intermedrelax( std::string val ) {
		intermedrelax_ = val;
	}

	void refine( std::string val ) {
		refine_ = val;
	}

	void relax( std::string val ) {
		relax_ = val;
	}

	void loops( protocols::loops::Loops val ) {
		loops_ = val;
	}

	void frag_libs( utility::vector1< core::fragment::FragSetOP > new_libs );

	bool cmd_line_csts() const {
		 return cmd_line_csts_;
	}

	bool copy_sidechains() const {
		 return copy_sidechains_;
	}

	core::Size n_rebuild_tries() const {
		 return n_rebuild_tries_;
	}

	core::Real rebuild_filter() const {
		 return rebuild_filter_;
	}

	protocols::loops::Loops get_loops() const {
		return loops_;
	}

	std::string remodel () const {
		return remodel_;
	}

	std::string relax() const {
		return relax_;
	}

	std::string intermedrelax() const {
		return intermedrelax_;
	}

	std::string refine() const {
		return refine_;
	}

	utility::vector1< core::fragment::FragSetOP > frag_libs() const;


private:
	void set_defaults_();

	bool cmd_line_csts_;
	bool copy_sidechains_;

	core::Size n_rebuild_tries_;
	core::Real rebuild_filter_;

	std::string remodel_;
	std::string intermedrelax_;
	std::string refine_;
	std::string relax_;

	loops::Loops loops_;

	core::scoring::ScoreFunctionOP cen_scorefxn_;
	core::scoring::ScoreFunctionOP fa_scorefxn_;

	utility::vector1< core::fragment::FragSetOP > frag_libs_;
};

} // namespace loops
} // namespace protocols

#endif // INCLUDED_protocols_loops_LoopRelaxMover_HH

