// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/match/output/MatchConsolidator.hh
/// @brief
/// @author Alex Zanghellini (zanghell@u.washington.edu)
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com), porting to mini

#ifndef INCLUDED_protocols_match_output_MatchConsolidator_HH
#define INCLUDED_protocols_match_output_MatchConsolidator_HH

// Unit headers
#include <protocols/match/output/MatchConsolidator.fwd.hh>

// Package headers
#ifdef WIN32
#include <protocols/match/Hit.hh>
#endif
#include <protocols/match/output/MatchProcessor.hh>
#include <protocols/match/output/MatchEvaluator.fwd.hh>
#include <protocols/match/output/MatchFilter.fwd.hh>
#include <protocols/match/output/MatchGrouper.fwd.hh>

// Project headers
#include <core/types.hh>

// Utility headers
#include <utility/pointer/ReferenceCount.hh>
// AUTO-REMOVED #include <utility/vector1.hh>

// C++ headers
#include <list>

//Auto Headers
#include <utility/vector1_bool.hh>


namespace protocols {
namespace match {
namespace output {

class MatchConsolidator : public MatchProcessor {
public:
	typedef core::Real Real;
	typedef core::Size Size;
public:
	MatchConsolidator();

	virtual
	~MatchConsolidator();

	virtual
	void
	begin_processing();

	virtual
	void
	process_match(
		match const & m
	);

	virtual
	void
	process_match(
		match_dspos1 const & m
	);

	virtual
	void
	end_processing();

	void
	set_n_to_output_per_group( Size setting );

	void
	add_filter( MatchFilterOP filter );

	void
	set_grouper( MatchGrouperOP grouper );

	void
	set_evaluator( MatchEvaluatorOP evaluator );

	//void
	//set_output_writer( OutputWriterOP writer );

	void
	reset_grouper();

private:
	void end_processing_of_regular_match_groups();
	void end_processing_of_match_dspos1_groups();

private:

	std::list< MatchFilterOP > filters_; /// NOTE: these filters are not given the opportunity to accumulate state.

	MatchGrouperOP   grouper_;
	MatchEvaluatorOP evaluator_;

	Size n_to_output_per_group_;

	//OutputWriterOP writer_;

	utility::vector1< std::list< match > > match_groups_;
	utility::vector1< std::list< match_dspos1 > > match_dspos1_groups_;

};

}
}
}

#endif
