// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/match/output/MatchProcessor.hh
/// @brief
/// @author Alex Zanghellini (zanghell@u.washington.edu)
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com), porting to mini

#ifndef INCLUDED_protocols_match_output_MatchProcessor_HH
#define INCLUDED_protocols_match_output_MatchProcessor_HH

// Unit headers
#include <protocols/match/output/MatchProcessor.fwd.hh>

// Package headers
#include <protocols/match/Hit.fwd.hh>
#include <protocols/match/output/OutputWriter.fwd.hh>

// Utility headers
#include <utility/pointer/ReferenceCount.hh>

// c++ headers
#include <map>

namespace protocols {
namespace match {
namespace output {

class MatchProcessor : public utility::pointer::ReferenceCount {
public:

	MatchProcessor();

	virtual
	~MatchProcessor();

	/// @brief Invoked by the Matcher before it begins feeding matches to the processor.
	/// Base-class has a no-op implementation.
	virtual
	void
	begin_processing();

	virtual
	void
	process_match(
		match const & m
	) = 0;

	virtual
	void
	process_match(
		match_dspos1 const & m
	) = 0;

	/// @brief Invoked by the Matcher after it finishes feeding matches to the processor.
	/// Base-class has a no-op implementation.
	virtual
	void
	end_processing();

	bool
	match_processing_successful() const {
		return match_processing_successful_; }

	void
	set_output_writer( OutputWriterOP writer );

	/// @brief const access to the output writer, e.g.
	/// for the MatcherMover when incorporating matches
	/// into the pose
	OutputWriterOP
	output_writer();

protected:

	void
	note_filter_fail( std::string filter_name );

	void
	note_match_processed();

	bool match_processing_successful_;

	OutputWriterOP writer_;

private:

	std::map< std::string, core::Size > filter_failcounts_;
	core::Size num_matches_processed_;
};

}
}
}

#endif
