// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief Keeps track of the acceptance_rate of a Mover
/// @author Monica Berrondo August 16 2007


#ifndef INCLUDED_protocols_moves_MoverStatistics_HH
#define INCLUDED_protocols_moves_MoverStatistics_HH


// Package headers
#include <core/types.hh>

//#include <core/util/basic.hh>

#include <protocols/moves/MonteCarlo.fwd.hh>

// ObjexxFCL Headers
// AUTO-REMOVED #include <ObjexxFCL/format.hh>

// C++ Headers
// AUTO-REMOVED #include <string>
#include <sstream>
#include <vector>

// Utility Headers
#include <utility/pointer/ReferenceCount.hh>

namespace protocols {
namespace moves {


///////////////////////////////////////////////////////////////////////////////
// @brief MoverStatistics keeps track of the acceptance_rate for a mover
//

class MoverStatistics : public utility::pointer::ReferenceCount {

public:

	// default constructor
	MoverStatistics():
		accepted_(0),
		rejected_(0),
		thermal_accepts_(0),
		downhill_accepts_(0)

	{}

	void accepted( bool result ) const
	{
		if ( result )	accepted_++;
		else rejected_++;
	}

	void add_score( core::Real score_in ) { score_.push_back(score_in); }

	void clear_score() { score_.clear(); }

	void print ( MonteCarloOP mc, std::string const type );

	core::Real acceptance_rate() const { return (core::Real)accepted_/(accepted_+rejected_+1e-100); }

	int num_accepted() const { return accepted_; }

	void clear()
	{
		accepted_ = 0;
		rejected_ = 0;
		thermal_accepts_ = 0;
		downhill_accepts_ = 0;

	}

private:
	mutable int accepted_; ///< number of accepted moves
	mutable int rejected_; ///< number of rejected moves
	std::vector < core::Real > score_;
	Size thermal_accepts_;
	Size downhill_accepts_;
}; // MoverStatistics class
} // moves
} // rosetta


#endif
