// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/qsar/qsarTypeManager.cc
/// @author Sam DeLuca

#include <protocols/qsar/qsarTypeManager.hh>

#include <utility/exit.hh>

namespace protocols {
namespace qsar {

bool qsarTypeManager::initialized_(false);
std::map<std::string, qsarType > qsarTypeManager::name2qsar_type_;
utility::vector1<std::string> qsarTypeManager::qsar_type2name_;

void qsarTypeManager::setup_qsar_type_names()
{
	if(initialized_)
		return;
	initialized_ = true;

	///if you add something to this map you must add a corresponding
	///entry to the qsarType enum
	///in protocols/ligand_docking/qsar/qsarTypeManager.fwd.hh
	name2qsar_type_[ "atr" ] = atr;
	name2qsar_type_[ "rep" ] = rep;
	name2qsar_type_[ "hba" ] = hba;
	name2qsar_type_[ "hbd" ] = hbd;
	name2qsar_type_[ "polariz" ] = polariz;

	assert(name2qsar_type_.size() == number_of_qsarTypes);
	qsar_type2name_.resize(number_of_qsarTypes);

	std::map<std::string,qsarType>::const_iterator map_iterator(name2qsar_type_.begin());
	for(; map_iterator != name2qsar_type_.end();++map_iterator)
	{
		qsar_type2name_[map_iterator->second]=map_iterator->first;
	}
}

qsarType qsarTypeManager::qsar_type_from_name(std::string const & name)
{
	setup_qsar_type_names();
	std::map<std::string, qsarType>::const_iterator map_iterator(name2qsar_type_.find(name));
	if(map_iterator == name2qsar_type_.end())
		utility_exit_with_message("unrecognized qsar type " +name);
	return map_iterator->second;
}

std::string qsarTypeManager::name_from_qsar_type(qsarType const & qsar_type)
{
	setup_qsar_type_names();
	return qsar_type2name_[qsar_type];
}

bool qsarTypeManager::is_qsar_type(std::string const & name)
{
	setup_qsar_type_names();
	std::map<std::string, qsarType>::const_iterator map_iterator(name2qsar_type_.find(name));
	return map_iterator != name2qsar_type_.end();
}

}
}
