// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#include "boost/python.hpp"


#include <protocols/moves/Mover.hh>

//#include <protocols/moves/TrialMover.hh>
#include <protocols/moves/BackboneMover.hh>
//#include <protocols/moves/MonteCarlo.hh>

#include <iostream>

namespace bp = boost::python;

class PyMover : public protocols::moves::Mover
{
public:
	virtual std::string get_name() const { return "PyMover"; };

	virtual void apply( Pose & ) {
	    	//std::cout << "PyMover:apply..." << std::endl;
	};
};

struct Wrapper_PyMover : public PyMover, bp::wrapper<PyMover>
{

	void apply( Pose & pose )
    {
    	//std::cout << "Wrapper_Mover:apply..." << std::endl;
    	bp::override f = this->get_override("apply");
    	if( f ) f(pose);
    	else this->PyMover::apply(pose);
    }

    void default_apply( Pose & pose ) {
	    //std::cout << "Wrapper PyMover default_apply..." << std::endl;
    	this->PyMover::apply(pose);
    }
};


/*
utility::pointer::owning_ptr< ::protocols::moves::Mover > toMover(utility::pointer::owning_ptr< ::protocols::moves::ShearMover > mp)
{
	return mp;
}

utility::pointer::owning_ptr< ::protocols::moves::MonteCarlo > toMC(utility::pointer::owning_ptr< ::protocols::moves::MonteCarlo > mp)
{
	return mp;
}
*/

void wrap__moves__by_hand()
{
    bp::implicitly_convertible< utility::pointer::owning_ptr< ::protocols::moves::Mover >
                              , utility::pointer::owning_ptr< ::protocols::moves::Mover const > >();

   bp::implicitly_convertible< utility::pointer::owning_ptr<  PyMover >
                              , utility::pointer::owning_ptr< ::protocols::moves::Mover > >();



   bp::implicitly_convertible< utility::pointer::owning_ptr<  Wrapper_PyMover >
                              , utility::pointer::owning_ptr< ::protocols::moves::Mover > >();

   bp::implicitly_convertible< utility::pointer::owning_ptr< Wrapper_PyMover >
                              , utility::pointer::owning_ptr< Wrapper_PyMover const > >();


    //boost::python::class_<Wrapper_Mover, bp::bases< ::protocols::moves::Mover >, utility::pointer::owning_ptr<PyMover>, boost::noncopyable>( "PyMover" )
    boost::python::class_<Wrapper_PyMover, utility::pointer::owning_ptr<Wrapper_PyMover>, boost::noncopyable>( "PyMover" )
		.def("apply", &PyMover::apply, &Wrapper_PyMover::default_apply)

    //bp::class_< protocols::moves::Mover, utility::pointer::owning_ptr< ::protocols::moves::Mover >, boost::noncopyable >( "Mover", ":\nA mover is an object that can apply a conformational change to a pose\n@detailed:\nEach derived class should define its own apply() statement\nDO NOT JUST GO ADDING FUNCTIONS TO THIS CLASS.  YOU IMPLY EVERYONE WHO\nDERIVES FROM IT IS OBLIGATED TO IMPLEMENT THAT FUNCTION, OR, IF THEY\nDONT, THAT THEY ARE IMPLICTLY AGREEING THAT THE BASE CLASS IMPLEMENTATION\nIS CORRECT.\nAuthor:s Monica Berrondo, Jeff Gray, Steven Lewis, Sarel Fleishman\niast_modified\n", bp::no_init )
        /*.def(
            "apply"
            , (void ( ::protocols::moves::Mover::* )( ::core::pose::Pose & ) )( &::protocols::moves::Mover::apply )
            , ( bp::arg("arg0") )
            , "Mover.hh:91" ) */
            /*
        .def(
            "clear_info"
            , (void ( ::protocols::moves::Mover::* )(  ) )( &::protocols::moves::Mover::clear_info )
            , "Strings container can be used to return miscellaneous info (as std::string) from a mover, such as notes about the results of apply(). The job distributor (Apr 09 vintage) will check this function to see if your protocol wants to add string info to the Job that ran this mover. One way this can be useful is that later, a JobOutputter may includeappend this info to an output file.\nclear_info is called by jd2 before calling apply" )
        .def(
            "clone"
            , (::protocols::moves::MoverOP ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::clone )
            , "clone has to be overridden only if clone invocation is expected." )
        .def(
            "fresh_instance"
            , (::protocols::moves::MoverOP ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::fresh_instance )
            , "this is like clone(), except it generates a new mover object freshly created with the default ctor.  This function _should_ be pure virtual but that would disrupt the code base; MAKE SURE YOU DEFINE IT if you want to have your mover be a protocol handed to the job distributor (august 08 vintage)." )
        .def(
            "get_current_job"
            , (::protocols::jobdist::BasicJobCOP ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_current_job )
            , "Mover.hh:180" )
        .def(
            "get_current_tag"
            , (::std::string ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_current_tag )
            , "A tag is a unique identifier used to identify structures produced\nby this Mover. get_current_tag() returns the tag, and set_current_tag( std::string tag )\nsets the tag.  This functionality is not intended for use with the 2008 job distributor." )
        .def(
            "get_input_pose"
            , (::core::pose::PoseCOP ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_input_pose )
            , "Mover.hh:111" )
        .def(
            "get_last_move_status"
            , (::protocols::moves::MoverStatus ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_last_move_status )
            , "returns status after an apply().  The job distributor (august 08 vintage) will check this function to see if your protocol wants to filter its results - if your protocol wants to say that run was no good, skip it then use the protected last_move_status(MoverStatus) to change the value that this function will return." )
        .def(
            "get_name"
            , (::std::string ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_name )
            , "Each derived class must specify its name.  The class name." )
        .def(
            "get_native_pose"
            , (::core::pose::PoseCOP ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_native_pose )
            , "Mover.hh:112" )
        .def(
            "get_type"
            , (::std::string ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::get_type )
            , "Each derived class must specify its name.  The class name." )
        .def(
            "info"
            , (::std::list< std::string > & ( ::protocols::moves::Mover::* )(  ) )( &::protocols::moves::Mover::info )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "non-const accessor" )
        .def(
            "info"
            , (::std::list< std::string > const & ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::info )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "const accessor" )
        .def(
            "last_proposal_density_ratio"
            , (::core::Real ( ::protocols::moves::Mover::* )(  ) )( &::protocols::moves::Mover::last_proposal_density_ratio )
            , "Mover.hh:84" )
        .def(
            "register_options"
            , (void (*)(  ))( &::protocols::moves::Mover::register_options )
            , "overload this static method if you access options within the mover.\nthese options will end up in -help of your application if users of this mover call register_options. do this recursively\nif you use movers within your mover, call their register_options in your register_options() method." )
        .def(
            "reinitialize_for_each_job"
            , (bool ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::reinitialize_for_each_job )
            , "this function informs the job distributor (august 08 vintage) whether this object needs to be freshly regenerated on each use." )
        .def(
            "reinitialize_for_new_input"
            , (bool ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::reinitialize_for_new_input )
            , "this function informs the job distributor (august 08 vintage) whether this object needs to be regenerated when the input pose is about to change (for example, if the mover has special code on the first apply() that is only valid for that one input pose)." )
        .def(
            "reset_status"
            , (void ( ::protocols::moves::Mover::* )(  ) )( &::protocols::moves::Mover::reset_status )
            , "resets status to SUCCESS, meant to be used before an apply().  The job distributor (august 08 vintage) uses this to ensure non-accumulation of status across apply()s." )
        .def(
            "set_current_job"
            , (void ( ::protocols::moves::Mover::* )( ::protocols::jobdist::BasicJobCOP ) )( &::protocols::moves::Mover::set_current_job )
            , ( bp::arg("job") )
            , "end Job Distributor interface" )
        .def(
            "set_current_tag"
            , (void ( ::protocols::moves::Mover::* )( ::std::string const & ) )( &::protocols::moves::Mover::set_current_tag )
            , ( bp::arg("new_tag") )
            , "Mover.hh:103" )
        .def(
            "set_input_pose"
            , (void ( ::protocols::moves::Mover::* )( ::core::pose::PoseCOP ) )( &::protocols::moves::Mover::set_input_pose )
            , ( bp::arg("pose") )
            , "setter for poses contained for rms" )
        .def(
            "set_native_pose"
            , (void ( ::protocols::moves::Mover::* )( ::core::pose::PoseCOP ) )( &::protocols::moves::Mover::set_native_pose )
            , ( bp::arg("pose") )
            , "setter for native poses contained for rms ---- we should get rid of this method? it is widely used, but a bit unsafe" )
        .def(
            "test_move"
            , (void ( ::protocols::moves::Mover::* )( ::core::pose::Pose & ) )( &::protocols::moves::Mover::test_move )
            , ( bp::arg("pose") )
            , ": Unit test support function.  Apply one move to a given pose.\nAllows extra test specific functions to be called before applying" )
        .def(
            "type"
            , (::std::string const & ( ::protocols::moves::Mover::* )(  ) const)( &::protocols::moves::Mover::type )
            , bp::return_value_policy< bp::copy_const_reference >()
            , "Mover.hh:93" )
        .def(
            "type"
            , (void ( ::protocols::moves::Mover::* )( ::std::string const & ) )( &::protocols::moves::Mover::type )
            , ( bp::arg("type_in") )
            , "protected:\nOL 42308 made this public. it is not really a safety issue to have that\nprotected and it allows more detail in MC diagnosis" )
        .staticmethod( "register_options" )
        .def( bp::self_ns::str( bp::self ) )
        .def( bp::self_ns::str( bp::self ) )*/
    ;


  /*  bp::def("toMover", toMover);
    bp::def("toMC", toMC);

    bp::implicitly_convertible< utility::pointer::owning_ptr< ::protocols::moves::TrialMover >
                              , utility::pointer::owning_ptr< ::protocols::moves::Mover > >();

    bp::implicitly_convertible< utility::pointer::owning_ptr< ::protocols::moves::SmallMover >
                              , utility::pointer::owning_ptr< ::protocols::moves::Mover > >();

    bp::implicitly_convertible< utility::pointer::owning_ptr< ::protocols::moves::ShearMover >
                              , utility::pointer::owning_ptr< ::protocols::moves::Mover > >();
*/
}
