// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/TorsionBinIO.cxxtest.hh
/// @brief
/// @author James Thompson

// Test headers
#include <cxxtest/TestSuite.h>
#include <test/core/init_util.hh>

#include <core/types.hh>
#include <core/util/Tracer.hh>
#include <core/fragment/picking/TorsionBinIO.hh>
#include <utility/io/izstream.hh>

//Auto Headers
#include <core/util/OStream.hh>


static core::util::Tracer tr("core.fragment.ConstantLengthFragments.cxxtest");
//MY_TRACERS("core.fragment.ConstantLengthFragments.cxxtest")

class TorsionBinIOTests : public CxxTest::TestSuite {
public:
	TorsionBinIOTests() {};

	// Shared initialization goes here.
	void setUp() {
		core_init();
	}

	// tests
	void test_read_file() {
		core::fragment::picking::TorsionBinIO tb_io;
		tb_io.read( utility::io::izstream( "core/fragment/picking/t286_.6.csts" ) );
		core::Real const DELTA( 1e-5 );

		TS_ASSERT( tb_io.nrows() == 200 );
		TS_ASSERT_DELTA( tb_io.prof_row(1)  [5], 0.006,    DELTA );
		TS_ASSERT_DELTA( tb_io.prof_row(20) [3], 0.057022, DELTA );
		TS_ASSERT_DELTA( tb_io.prof_row(200)[2], 0.782440, DELTA );
	}

	// Shared finalization goes here.
	void tearDown() {}

private:

}; // TorsionBinIOTests
