// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   utility/string_util.cxxtest.hh
/// @brief  string_util.cxxtest: test suite for utility::string_util
/// @author James Thompson


// Testing headers
#include <cxxtest/TestSuite.h>
#include <utility/string_util.hh>

#include <string>
#include <iostream>

class StringUtilTests : public CxxTest::TestSuite {
public:

	void test_file_basename() {
		std::string const full_name( "core/scoring/ScoreFunction.cc" );
		std::string const basename( utility::file_basename( full_name ) );

		TS_ASSERT_EQUALS( std::string("ScoreFunction.cc"),  basename );
	}
};
