// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file /src/apps/pilat/andre/SymDock.cc
/// @brief  Symmetric Docking protocol

// libRosetta headers
#include <protocols/symmetric_docking/SymDockProtocol.hh>
#include <protocols/moves/symmetry/SetupForSymmetryMover.hh>
#include <protocols/moves/MoverContainer.hh>


//#include <core/pose/Pose.fwd.hh>
#include <core/pose/Pose.hh>

#include <protocols/jd2/JobDistributor.hh>

//#include <protocols/moves/Mover.fwd.hh>
#include <protocols/moves/Mover.hh>

#include <protocols/init.hh>

// C++ headers
//#include <cstdlib>
#include <iostream>
#include <string>

#include <core/util/Tracer.hh>

// option key includes

using core::util::T;
using core::util::Error;
using core::util::Warning;

using namespace core;

int
main( int argc, char * argv [] )
{
	using namespace protocols::symmetric_docking;
	using namespace protocols::moves::symmetry;
	using namespace protocols::jd2;

	// initialize core
	protocols::init(argc, argv);

	SetupForSymmetryMoverOP setup_mover = new SetupForSymmetryMover;
	SymDockProtocolOP dock_mover = new SymDockProtocol;
	protocols::moves::SequenceMoverOP seq_mover = new protocols::moves::SequenceMover;
	seq_mover->add_mover( setup_mover );
	seq_mover->add_mover( dock_mover );
	protocols::jd2::JobDistributor::get_instance()->go( seq_mover );
}
