// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Mike Tyka & Phil bradley
/// @brief


// libRosetta headers
#include <protocols/idealize/idealize.hh>
#include <protocols/idealize/IdealizeMover.hh>
#include <protocols/moves/symmetry/SetupForSymmetryMover.hh>
#include <protocols/moves/MoverContainer.hh>

#include <protocols/jd2/JobDistributor.hh>
#include <utility/excn/Exceptions.hh>

#include <core/options/option.hh>

#include <protocols/init.hh>



// C++ headers
//#include <cstdlib>
#include <iostream>
#include <string>

using namespace core;

#include <core/options/option_macros.hh>
#include <core/options/keys/symmetry.OptionKeys.gen.hh>

//Auto Headers
#include <protocols/moves/MoverStatistics.hh>


OPT_KEY( Real, atom_pair_constraint_weight )
OPT_KEY( Real, coordinate_constraint_weight )
OPT_KEY( Boolean, fast )

void
register_options() {
  using namespace core::options;
  using namespace core::options::OptionKeys;
  NEW_OPT( atom_pair_constraint_weight, "atompair constraint weight", 0.0 );
  NEW_OPT( coordinate_constraint_weight, "coordinate constraint weight", 0.0 );
  NEW_OPT( fast, "fast protocol", false );
}


int main( int argc, char * argv [] )
{
  using namespace protocols;
  using namespace protocols::moves;
  using core::options::option;
	using namespace core::options;
  using namespace core::options::OptionKeys;


  register_options();
  protocols::init(argc, argv);

	// set some idealize mover
	protocols::idealize::IdealizeMover idealizer;
	if ( option[ coordinate_constraint_weight ].user() ) {
		idealizer.coordinate_constraint_weight( option[ coordinate_constraint_weight ]() ) ;
	}
	if ( option[ atom_pair_constraint_weight ].user() ) {
		idealizer.atom_pair_constraint_weight( option[ atom_pair_constraint_weight ]() );
	}
	idealizer.fast( option[ fast ]() );

	MoverOP mover (idealizer);

	// optionally set pose for symmetry
	if ( option[ OptionKeys::symmetry::symmetry_definition ].user() )  {
		protocols::moves::SequenceMoverOP seqmov = new protocols::moves::SequenceMover;
		seqmov->add_mover( new protocols::moves::symmetry::SetupForSymmetryMover );
		seqmov->add_mover( mover );
		mover = seqmov;
	}

  try {
    protocols::jd2::JobDistributor::get_instance()->go( mover );
  } catch ( utility::excn::EXCN_Base & excn ) {
    std::cerr << "Exception: " << std::endl;
    excn.show( std::cerr );
    std::cout << "Exception: " << std::endl;
    excn.show( std::cout ); //so its also seen in a >LOG file
  }
  return 0;
}

