// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/BestTotalScoreSelector.hh
/// @brief provides a selector that picks best fragments based on their total score
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_BestTotalScoreSelector_HH
#define INCLUDED_core_fragment_picking_BestTotalScoreSelector_HH

#include <core/fragment/picking/BestTotalScoreSelector.fwd.hh>

#include <core/fragment/picking/FragmentSelectingRule.hh>

// package headers
#include <core/fragment/picking/FragmentCandidate.hh>
#include <core/fragment/picking/CommonFragmentComparators.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>
#include <core/fragment/picking/scores/FragmentScoreManager.hh>

// utility headers
#include <core/types.hh>
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/ReferenceCount.hh>

namespace core {
namespace fragment {
namespace picking {

/// @brief selects a given number of fragments using a quota scheme
class BestTotalScoreSelector: public FragmentSelectingRule {
public:

	/// @brief  Constructor sets the desired number of fragments.
	BestTotalScoreSelector(Size frags_per_pos,
			scores::FragmentScoreManagerOP scoring_scheme) :
		FragmentSelectingRule(frags_per_pos), comparator_(scoring_scheme) {

	}

	virtual ~BestTotalScoreSelector() {
	}

	/// @brief  Selects desired number of fragments from a given candidates
	virtual void select_fragments(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >&,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >&);

private:
	CompareTotalScore comparator_;
};


} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_BestTotalScoreSelector_HH */
