// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/CompositeFragmentSelector.cc
/// @brief provides a selector that picks best fragments based on their total score
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#include <core/fragment/picking/CompositeFragmentSelector.hh>

// package headers
#include <core/fragment/picking/FragmentCandidate.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

#include <utility/vector1.hh>

namespace core {
namespace fragment {
namespace picking {

	/// @brief  Selects desired number of fragments from a given set of candidates
void CompositeFragmentSelector::select_fragments(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >& in,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >& out) {

    if(selectors_.size()==0) return;
    if(selectors_.size()==1) {
	selectors_[1]->select_fragments(in,out);
	return;
    }
    Size n = selectors_.size();
    utility::vector1<std::pair<FragmentCandidateOP, scores::FragmentScoreMapOP> > tmp;
    utility::vector1<std::pair<FragmentCandidateOP, scores::FragmentScoreMapOP> > tmp_tmp;
    selectors_[1]->select_fragments(in,tmp);
    for(Size i=2;i<=n-1;i++) {
	selectors_[i]->select_fragments(tmp,tmp_tmp);
	tmp.clear();
	for(Size j=1;j<=tmp_tmp.size();j++)
	    tmp.push_back(tmp_tmp[j]);
    }
    selectors_[n]->select_fragments(tmp,out);
}

} // picking
} // fragment
} // core
