// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/DiversifyCrmsdSelector.hh
/// @brief provides a selector that picks best fragments based on their total score
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_DiversifyCrmsdSelector_HH
#define INCLUDED_core_fragment_picking_DiversifyCrmsdSelector_HH

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/FragmentSelectingRule.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

#include <core/pose/Pose.fwd.hh>

#include <core/types.hh>

#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray1D.hh>

#include <utility/vector1.fwd.hh>


namespace core {
namespace fragment {
namespace picking {

using namespace ObjexxFCL;

/// @brief selects fragments by running several selectors
class DiversifyCrmsdSelector: public FragmentSelectingRule {
public:

	/// @brief  Constructor sets the desired number of fragments and crmsd cutoff.
	DiversifyCrmsdSelector(Size frags_per_pos,Real cutoff) : FragmentSelectingRule(frags_per_pos) {
		cutoff_ = cutoff;
	}

	/// @brief  Selects desired number of fragments from a given set of candidates
	virtual void select_fragments(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >&,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >&);

	virtual ~DiversifyCrmsdSelector() {
	}

private:
	void copy_coordinates(FragmentCandidateOP src,FArray2D_double & dst);
	Real cutoff_;
	FArray2D_double fi_;
	FArray2D_double fj_;
	FArray1D_double weights_;
};

} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_DiversifyCrmsdSelector_HH */
