// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/scores/ProlinePhiScore.hh
/// @brief  a base class for fragment scoring
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_scores_ProlinePhiScore_HH
#define INCLUDED_core_fragment_picking_scores_ProlinePhiScore_HH

// type headers
#include <core/types.hh>

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/FragmentPicker.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.hh>

namespace core {
namespace fragment {
namespace picking {
namespace scores {

/// @brief  ProlinePhiScore score counts identical residues
/// @detailed Resulting score is the number of identical residues
/// on corresponding positions in a vall fragment and a query sequence
class ProlinePhiScore: public FragmentScoringMethod {
public:
	/// @brief will be added if the two residues are identical
	static const int REWARD = 0;
	/// @brief will be added if the two residues are NOT identical
	static const int PENALTY = 1;

	ProlinePhiScore(Size priority, Real lowest_acceptable_value, bool use_lowest,
			std::string & fastaQueryDisulfide) :
		FragmentScoringMethod(priority, lowest_acceptable_value, use_lowest,
				"ProlinePhiScore"), query_(fastaQueryDisulfide) {
	}

	bool score(FragmentCandidateOP f, FragmentScoreMapOP empty_map);

	/// @brief prints a detailed explanation how a fragment score has been computed
	/// @detailed besides extensive output, the method should return the same result as score()
	bool describe_score(FragmentCandidateOP f, FragmentScoreMapOP empty_map,
			std::ostream& out);

private:
	Real minScoreAllowed_;
	std::string& query_;
};

/// @brief  Maker class that produces a new ProlinePhiScore object
class MakeProlinePhiScore: public MakeFragmentScoringMethod {
public:

	MakeProlinePhiScore() :
		MakeFragmentScoringMethod("ProlinePhiScore") {
	}

	FragmentScoringMethodOP make(Size priority, Real lowest_acceptable_value, bool use_lowest,
			FragmentPickerOP picker, std::string) {
		return (FragmentScoringMethodOP) new ProlinePhiScore(priority,
				lowest_acceptable_value, use_lowest, picker->get_query_seq_string());
	}
};

} // scores
} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_scores_ProlinePhiScore_HH */
