// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


/// @file   core/mm/MMLJScore.fwd.hh
/// @brief  core::mm::MMLJScore forward declarations
/// @author P. Douglas Renfrew (renfrew@unc.edu)


#ifndef INCLUDED_core_mm_mm_lj_score_FWD_HH
#define INCLUDED_core_mm_mm_lj_score_FWD_HH

#include <utility/pointer/access_ptr.fwd.hh>
#include <utility/pointer/owning_ptr.fwd.hh>

namespace core {
namespace mm {


// Forward
class MMLJScore;

typedef  utility::pointer::access_ptr< MMLJScore > MMLJScoreAP;
typedef  utility::pointer::access_ptr< MMLJScore const > MMLJScoreCAP;
typedef  utility::pointer::owning_ptr< MMLJScore > MMLJScoreOP;
typedef  utility::pointer::owning_ptr< MMLJScore const > MMLJScoreCOP;

} // namespace mm
} // namespace core


#endif // INCLUDED_core_mm_mm_lj_score_FWD_HH
