// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/rotamer_set/RotamerSetCacheableDataType.hh
/// @brief  enum for the DataCache within the RotamerSet class
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_core_pack_rotamer_set_RotamerSetCacheableDataType_HH
#define INCLUDED_core_pack_rotamer_set_RotamerSetCacheableDataType_HH


namespace core {
namespace pack {
namespace rotamer_set {


// hold the enum within a descriptive namespace to avoid name collisions
namespace RotamerSetCacheableDataType {

/// @brief enum indexing the types for the DataCache within the RotamerSet class
enum Enum {
	GEN_BORN_ROTAMER_SET_INFO = 1,
	// *** IMPORTANT ***
	// The 'num_cacheable_data_types' below must be the last enum, and must
	// always be set equal to the (last-1) enum.  If you append a new enum
	// to the list, remember to change the value below!
	num_cacheable_data_types = GEN_BORN_ROTAMER_SET_INFO
};

} // namespace RotamerSetCacheableDataType


} // namespace rotamer_set
} // namespace pack
} // namespace core


#endif /* INCLUDED_core_pack_rotamer_set_RotamerSetCacheableDataType_HH */
