// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

// Rosetta Headers
#include <core/scoring/hbonds/constants.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray2D.hh>
#include <core/options/option.hh>
#include <core/options/keys/corrections.OptionKeys.gen.hh>

// Using

namespace core {
namespace scoring {
namespace hbonds {

core::Real LR_MIN_R_CUT()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[1] < 0) {
		return INTERP_MIN;
	}
	else {
		return fade_param[1];
	}
}

core::Real LR_MAX_R_CUT()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[4] < 0) {
		return MAX_R;
	}
	else {
		return fade_param[4];
	}
}

core::Real LR_MIN_R_FADE()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[2] < 0) {
		return INTERP_MAX;
	}
	else {
		return fade_param[2];
	}
}

core::Real LR_MAX_R_FADE()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[3] < 0) {
		return INTERP_MAX;
	}
	else {
		return fade_param[3];
	}
}
core::Real MIN_xD_CUT()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[5] < 0) {
		return 0.0;
	}
	else {
		return fade_param[5];
	}
}
core::Real MIN_xD_FADE()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[6] < 0) {
		return 0.05;
	}
	else {
		return fade_param[6];
	}
}
core::Real MIN_xH_CUT()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[7] < 0) {
		return 0.0;
	}
	else {
		return fade_param[7];
	}
}
core::Real MIN_xH_FADE()
{
	utility::vector1<core::Real> const & fade_param = core::options::option[ core::options::OptionKeys::corrections::score::hbond_fade ]();
	if (fade_param[8] < 0) {
		return 0.05;
	}
	else {
		return fade_param[8];
	}
}


} // hbonds
} // scoring
} // core
