// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file CrossPeakList.hh
/// @author Oliver Lange

#ifndef INCLUDED_protocols_NoesyAssign_PeakFileFormat_HH
#define INCLUDED_protocols_NoesyAssign_PeakFileFormat_HH


// Unit Headers
#include <protocols/NoesyAssign/CrossPeakInfo.hh>
#include <protocols/NoesyAssign/CrossPeak.hh>

// Package Headers

// Project Headers
#include <core/types.hh>
//#include <core/id/NamedAtomID.fwd.hh>
//#include <core/chemical/AA.hh>

// Utility headers
#include <utility/exit.hh>
// #include <utility/excn/Exceptions.hh>
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>
// #include <numeric/numeric.functions.hh>
// #include <core/util/prof.hh>
//#include <core/util/Tracer.hh>
// #include <core/options/option.hh>
// #include <core/options/keys/abinitio.OptionKeys.gen.hh>
// #include <core/options/keys/run.OptionKeys.gen.hh>
//#include <core/options/keys/templates.OptionKeys.gen.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <list>
#include <map>

namespace protocols {
namespace NoesyAssign {

class PeakFileFormat {
public:
  PeakFileFormat() {};
  virtual ~PeakFileFormat() {
    info1_->set_filename( filename() );
    info2_->set_filename( filename() );
  };

  virtual void write_peak( std::ostream&, core::Size ct, CrossPeak const& ) const = 0;
  virtual void write_resonances( std::ostream&, CrossPeak const& ) const = 0;
  virtual void write_strength( std::ostream&, CrossPeak const& ) const = 0;
  virtual void write_assignments( std::ostream&, CrossPeak const&, std::string const& first_line_end ) const = 0;

  virtual void read_resonances( std::istream&, CrossPeak& ) const = 0;
  virtual void read_assignments( std::istream&, CrossPeak& ) const = 0;
  virtual void read_strength( std::istream&, CrossPeak& ) const = 0;

  void set_filename( std::string str ) {
    filename_ = str;
  }
  std::string const& filename() const {
    return filename_;
  }

  virtual void set_format_from_peak( CrossPeak const& ) = 0;
  virtual void write_header( std::ostream& ) = 0;
  virtual bool compatible_with_current_format( CrossPeak const& ) const = 0;
  virtual CrossPeakOP read_peak( std::istream& ) const = 0;
  virtual void output_diagnosis( std::ostream& ) const {};
  virtual void read_header( std::istream& ) = 0;

  bool ignore_assignments() const {
    return ignore_assignments_;
  }
  void set_ignore_assignments( bool setting = true ) {
    ignore_assignments_ = setting;
  }

protected:
  CrossPeakInfoOP info1_;
  CrossPeakInfoOP info2_;
  std::string filename_;

private:
  bool ignore_assignments_;

  //  virtual void write_header( std::ostream& );
};

class PeakFileFormat_xeasy : public PeakFileFormat {
public:
  PeakFileFormat_xeasy();
  PeakFileFormat_xeasy( ResonanceListOP const& );
  virtual ~PeakFileFormat_xeasy();
  virtual void write_peak( std::ostream&, core::Size ct, CrossPeak const& ) const;
  virtual void write_resonances( std::ostream&, CrossPeak const& ) const;
  virtual void write_strength( std::ostream&, CrossPeak const& ) const;
  virtual void write_assignments( std::ostream&, CrossPeak const&, std::string const& first_line_end ) const;

  virtual void read_resonances( std::istream&, CrossPeak& ) const;
  virtual void read_assignments( std::istream&, CrossPeak& ) const;
  virtual void read_strength( std::istream&, CrossPeak& ) const;

  virtual CrossPeakOP read_peak( std::istream& ) const;
  virtual void read_header( std::istream& );
  //  virtual void write_header( std::ostream& );
  virtual void output_diagnosis( std::ostream& ) const;

  virtual void set_format_from_peak( CrossPeak const& );
  virtual void write_header( std::ostream& );
  virtual bool compatible_with_current_format( CrossPeak const& ) const;

  static void register_options();

  void set_write_atom_names( bool setting = true ) {
    write_atom_names_ = setting;
  }
protected:
  utility::vector1< std::string > column_labels_; //eg. NhH
  utility::vector1< core::Size > col2proton_; //up to 4 columns may read 1 1 2 2 or 1 2 1 (NhH) or 1 2 2 for hHN
  utility::vector1< bool > col2islabel_;  // woulde be 0 0 1 for hHN and 1 0 0 for NhH

private:
  static bool options_registered_;
  ResonanceListOP resonances_;
  bool write_atom_names_;
};

}
}

#endif
