// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file CrossPeakList.hh
/// @author Oliver Lange

#ifndef INCLUDED_protocols_NoesyAssign_Resonance_HH
#define INCLUDED_protocols_NoesyAssign_Resonance_HH


// Unit Headers
//#include <protocols/NoesyAssign/ResonanceList.fwd.hh>
#include <core/types.hh>

// Package Headers
#include <core/id/NamedAtomID.hh>

// Project Headers
#include <core/chemical/AA.hh>

// Utility headers
#include <utility/exit.hh>
// #include <utility/excn/Exceptions.hh>
#include <utility/vector1.hh>
//#include <utility/pointer/ReferenceCount.hh>
// #include <numeric/numeric.functions.hh>
// #include <core/util/prof.hh>
//#include <core/util/Tracer.hh>
// #include <core/options/option.hh>
// #include <core/options/keys/abinitio.OptionKeys.gen.hh>
// #include <core/options/keys/run.OptionKeys.gen.hh>
//#include <core/options/keys/templates.OptionKeys.gen.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <map>

namespace protocols {
namespace NoesyAssign {

class Resonance {
public:
  Resonance();
  Resonance( core::Size label, core::Real freq, core::Real error, core::id::NamedAtomID id );
  ~Resonance();
  void write_to_stream( std::ostream& ) const;
  core::Size label() const { return label_; } //resonance id
  core::id::NamedAtomID const& atom() const { return atom_; }
  core::Size resid() const { return atom_.rsd(); }
  std::string const& name() const { return atom_.atom(); }
  core::Real freq() const { return freq_; }
	core::Real error() const { return error_; }
	core::Real tolerance() const { return error_; }
private:
  core::Size label_;
  core::Real freq_;
  core::Real error_;
  core::id::NamedAtomID atom_;
};

}
}
#endif
