// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/DumpPdb.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

// Unit headers
#include <protocols/ProteinInterfaceDesign/movers/DumpPdb.hh>
#include <protocols/ProteinInterfaceDesign/movers/DumpPdbCreator.hh>


#include <core/pose/Pose.hh>
#include <utility/Tag/Tag.hh>
#include <core/util/Tracer.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace core;
using namespace std;
using namespace core::scoring;
using namespace protocols::moves;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.DumpPdb" );

std::string
DumpPdbCreator::keyname() const
{
	return DumpPdbCreator::mover_name();
}

protocols::moves::MoverOP
DumpPdbCreator::create_mover() const {
	return new DumpPdb;
}

std::string
DumpPdbCreator::mover_name()
{
	return "DumpPdb";
}

DumpPdb::DumpPdb() : protocols::moves::Mover( DumpPdbCreator::mover_name() ) {}
DumpPdb::DumpPdb( std::string const fname ) : protocols::moves::Mover( DumpPdbCreator::mover_name() ) { fname_ = fname; }

DumpPdb::~DumpPdb() {}

void DumpPdb::apply( core::pose::Pose & pose ) { pose.dump_pdb( fname_ ); }

void
DumpPdb::parse_my_tag( TagPtr const tag, DataMap &, protocols::filters::Filters_map const &, Movers_map const &, core::pose::Pose const & )
{
	fname_ = tag->getOption<std::string>( "fname", "dump.pdb" );
	TR<<"dump pdb\n";
	TR<<"WARNING: DEFINED DUMP_PDB MOVER. THIS IS USUALLY ONLY GOOD FOR DEBUGGING.\n";
	TR<<"with filename "<<fname_<<std::endl;
}

std::string
DumpPdb::get_name() const {
	return DumpPdbCreator::mover_name();
}

} //movers
} //ProteinInterfaceDesign
} //protocols
