// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/PlacementAuctionMover.hh
/// @brief definition of a class for making the placement auction used by PlaceSimultaneouslyMover
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_PlacementAuction_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_PlacementAuction_HH

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <core/types.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/ProteinInterfaceDesign/movers/DesignRepackMover.hh>
#include <protocols/hotspot_hashing/HotspotStubSet.hh>
#include <protocols/hotspot_hashing/HotspotStub.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/ProteinInterfaceDesign/movers/PlacementAuctionMover.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class PlacementAuctionMover : public DesignRepackMover
{
public:
	typedef std::pair< protocols::hotspot_hashing::HotspotStubSetOP, std::pair< protocols::hotspot_hashing::HotspotStubOP, core::Size > > StubSetStubPos;
	typedef std::pair< protocols::hotspot_hashing::HotspotStubSetOP, protocols::hotspot_hashing::HotspotStubOP > StubsetStubPair;
	typedef std::pair< core::Real, std::pair< core::Size, StubsetStubPair > > ResidueAuctionItem;
	typedef std::multimap< core::Real, std::pair< core::Size, StubsetStubPair > > ResidueAuction;
	typedef ResidueAuction::iterator iterator;
	typedef ResidueAuction::const_iterator const_iterator;
public:
	PlacementAuctionMover();
	void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;
	ResidueAuction auction_results() const;
	protocols::moves::MoverOP clone() const;
	protocols::moves::MoverOP fresh_instance() const {
		 return protocols::moves::MoverOP( new PlacementAuctionMover );
	}
	void insert( ResidueAuctionItem const & item );
	core::Size size() const;
	void erase( iterator it );
	void clear();
	iterator begin();
	iterator end();
	const_iterator begin() const;
	const_iterator end() const;
	virtual void parse_my_tag( utility::Tag::TagPtr const tag,
		protocols::moves::DataMap &,
		protocols::filters::Filters_map const &,
		protocols::moves::Movers_map const &,
		core::pose::Pose const & );
//// mutators for Placement movers to copy their internals onto auctionMover
	void host_chain( core::Size const hc );
	void max_cb_cb_dist( core::Real const mccd );
	void cb_force( core::Real const cf );
	void stub_sets( utility::vector1< StubSetStubPos > const & vec );
	utility::vector1< StubSetStubPos > const & stub_sets() const;
	utility::vector1< StubSetStubPos > & stub_sets();
	~PlacementAuctionMover();
private:
	ResidueAuction auction_results_;
	core::Size host_chain_;
	core::Real max_cb_cb_dist_, cb_force_;
	utility::vector1< StubSetStubPos > stub_sets_;
};

} //movers
} //ProteinInterfaceDesign
} //protocols

#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_PlacementAuction_HH*/

