// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file AbrelaxMover
/// @brief  this class will be handled to a SampleProtocol as a control instance
/// @detailed responsibilities:
///           know which chainbreaks to penalize and close
///           know which jumps to use during sampling, which (if any) to keep after loop-closing
///           supply a JumpMover if jumps should be moved
///           supply a MoveMap
///           supply a "StrictMoveMap": the protocol should not move anything that is dissallowed in strict_movemap(),
///                      it should try to move just stuff in movemap()
/// should this class also know how to ramp score terms ?
/// handle the titration of constraints ?
/// @author Oliver Lange


#ifndef INCLUDED_protocols_abinitio_AbrelaxMover_HH
#define INCLUDED_protocols_abinitio_AbrelaxMover_HH

// Unit Headers
#include <protocols/abinitio/AbrelaxMover.fwd.hh>
#include <protocols/abinitio/FragmentSampler.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/loops/SlidingWindowLoopClosure.fwd.hh>
#include <protocols/relax/RelaxProtocolBase.fwd.hh>
// Package Headers
#include <protocols/topology_broker/TopologyBroker.fwd.hh>
//#include <protocols/jumping/JumpSetup.hh>
//#include <protocols/abinitio/KinematicControl.hh>
//#include <protocols/Protocol.hh>
#include <protocols/checkpoint/CheckPointer.hh>
//#include <protocols/abinitio/ResolutionSwitcher.hh>

// Project Headers
#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>

// AUTO-REMOVED #include <protocols/loops/Loops.hh>

// ObjexxFCL Headers
//#include <ObjexxFCL/FArray1D.hh>
//#include <ObjexxFCL/FArray2D.hh>

// Utility headers
// AUTO-REMOVED #include <utility/vector1.hh>
//#include <utility/pointer/ReferenceCount.hh>

//// C++ headers
// AUTO-REMOVED #include <cstdlib>
#include <string>


namespace protocols {
namespace abinitio {

class AbrelaxMover : public moves::Mover {
public:
  AbrelaxMover();

	virtual ~AbrelaxMover();

	virtual void apply( core::pose::Pose &pose );

	virtual std::string get_name() const;

	void set_defaults();
	void clear(); //set's all pointers to zero

	virtual moves::MoverOP fresh_instance() const { return new AbrelaxMover(); }

	FragmentSamplerOP sampling_protocol();

	relax::RelaxProtocolBaseCOP relax_protocol() const;
	
	relax::RelaxProtocolBaseOP relax_protocol();

	loops::SlidingWindowLoopClosureOP closure_protocol();

	void sampling_protocol( FragmentSamplerOP set);

	void relax_protocol( relax::RelaxProtocolBaseOP set );

	void closure_protocol( loops::SlidingWindowLoopClosureOP set );

	void post_loop_closure_protocol( moves::MoverOP move );  //e.g. to idealize after loop-closing


	void pre_loop_closure_protocol( moves::MoverOP move ); //e.g. to idealize after loop-closing
	//	virtual checkpoint::CheckPointer &get_checkpoints() { return sampling_protocol_->get_checkpoints(); }

protected:

	topology_broker::TopologyBrokerOP topology_broker();

private:

	void close_with_idealization( core::pose::Pose &pose);

	topology_broker::TopologyBrokerOP topology_broker_;

	FragmentSamplerOP sampling_protocol_;
	loops::SlidingWindowLoopClosureOP loop_closure_protocol_;
	relax::RelaxProtocolBaseOP relax_protocol_;
	moves::MoverOP post_loop_closure_protocol_;
	moves::MoverOP pre_loop_closure_protocol_;

	bool b_return_unrelaxed_fullatom_;

	//	evaluation::MetaPoseEvaluatorOP evaluator_;

};



}
}

#endif
