// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file PoseEvaluator
/// @brief PoseEvaluator
/// @detailed
///
///
/// @author Oliver Lange



// Unit Headers
#include <protocols/evaluation/ChemicalShiftEvaluator.hh>

// Package Headers

// Project Headers
#include <core/io/silent/SilentStruct.hh>
#include <core/pose/Pose.hh>

// AUTO-REMOVED #include <core/options/option.hh>
// AUTO-REMOVED #include <core/options/keys/evaluation.OptionKeys.gen.hh>


// ObjexxFCL Headers
// AUTO-REMOVED #include <ObjexxFCL/string.functions.hh>

// Utility headers
#include <core/util/Tracer.hh>
#include <utility/exit.hh>
// AUTO-REMOVED #include <utility/file/file_sys_util.hh>

//Auto Headers
#include <utility/options/keys/BooleanOptionKey.hh>

// C++ headers

static core::util::Tracer tr("protocols.evaluation.ChemicalShiftEvaluator");

namespace protocols {
namespace evaluation {

using namespace core;



// ChemicalShiftEvaluator::ChemicalShiftEvaluator( std::string tag, std::string cs_file )
//   : ExternalEvaluator( tag )
// {
// 	#ifdef WIN32
// 	utility_exit_with_message("don't use ChemicalShiftEvaluator on a BillBox");
//   #endif
// 	//	if (!utility::file::file_exists( scratch_dir()+"/SPARTA" ) ) {
// 	// std::string command( "cp -Rf $HOME/SPARTA "+scratch_dir());
// 	std::string command( "rsync -azvu $HOME/SPARTA+ "+scratch_dir());
// 	int ret(system(command.c_str()));
// 	if( ret ){
// 		utility_exit_with_message("System command failed:'" + command + "'" );
// 	}
// 		//}
// 	set_command( "export SPARTA_DIR="+scratch_dir()+
// 		"/SPARTA+; $SPARTA_DIR/sparta+ -in __POSE.pdb  -sum tmp_RESULT -ref  "+cs_file+
//     "; cat tmp_RESULT | awk 'BEGIN { sum = 0.0; } NF~9&&$1!=""REMARK""&&$8>0.1{ sum = sum + $7*$7/($8*$8) } END { print sum/4 }' > __RESULT" );
// }

ChemicalShiftEvaluator::ChemicalShiftEvaluator( std::string tag, std::string cst_file ) :
	SingleValuePoseEvaluator<core::Real>( tag ),
	sparta_( cst_file )
{}

Real ChemicalShiftEvaluator::apply( pose::Pose& pose ) const {
	return sparta_.score_pose( pose );
}

bool ChemicalShiftEvaluator::applicable( pose::Pose const& pose ) const {
  return pose.is_fullatom();
}


}
}
