// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/filters/BasicFilters.hh
/// @brief header file for very simple Filter classes
/// @detailed
/// @author Florian Richter, floric@u.washington.edu (feb 09 ), Sarel Fleishman sarelf@u.washington.edu

#ifndef INCLUDED_protocols_filters_BasicFilters_HH
#define INCLUDED_protocols_filters_BasicFilters_HH

// Unit Headers
#include <protocols/filters/BasicFilters.fwd.hh>

// Package headers
#include <protocols/filters/Filter.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/moves/ResId.hh>

// Project Headers
#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>

// Utility headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>
#include <utility/Tag/Tag.fwd.hh>

//// C++ headers
#include <string>

namespace protocols {
namespace filters {

class TrueFilter : public Filter {
public:
	TrueFilter() : Filter( "TrueFilter" ) {}
	bool apply( core::pose::Pose const & ) const { return true; }
	FilterOP clone() const { return new TrueFilter; }
	FilterOP fresh_instance() const { return new TrueFilter; }
};

class FalseFilter : public Filter {
public:
	FalseFilter() : Filter( "FalseFilter" ) {}
	bool apply( core::pose::Pose const & ) const { return false; }
	FilterOP clone() const { return new FalseFilter; }
	FilterOP fresh_instance() const { return new FalseFilter; }
};

class StochasticFilter : public Filter {

public:
	StochasticFilter();
	virtual ~StochasticFilter();
	StochasticFilter( core::Real const confidence );
	bool apply( core::pose::Pose const & pose ) const;
	FilterOP clone() const;
	FilterOP fresh_instance() const;
	void report( std::ostream &, core::pose::Pose const & ) const {}

	void parse_my_tag(
		utility::Tag::TagPtr const tag,
		moves::DataMap &,
		Filters_map const &,
		moves::Movers_map const &,
		core::pose::Pose const & );

private:
	core::Real confidence_;
};

// @brief Used to define a compound logical statement involving other filters with
// AND, OR and XOR
class CompoundFilter : public Filter, public protocols::moves::ResId
{
public:
	typedef std::vector< std::pair< FilterOP, boolean_operations > > CompoundStatement;
	typedef CompoundStatement::iterator iterator;
	typedef CompoundStatement::const_iterator const_iterator;

public:
	CompoundFilter();
	virtual ~CompoundFilter();
	CompoundFilter( CompoundStatement const & );
	bool apply( core::pose::Pose const & ) const;
	FilterOP clone() const;
	FilterOP fresh_instance() const;
	void report( std::ostream &, core::pose::Pose const & ) const;
	core::Real report_sm( core::pose::Pose const & ) const;
	bool compute( core::pose::Pose const & ) const;
	void clear();
	iterator begin();
	const_iterator begin() const;
	iterator end();
	const_iterator end() const;
	virtual void set_resid( core::Size const resid );

	void parse_my_tag(
		utility::Tag::TagPtr const,
		moves::DataMap &,
		Filters_map const &,
		moves::Movers_map const &,
		core::pose::Pose const & );

private:
	CompoundStatement compound_statement_;
};



} // filters
} // protocols

#endif
