// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/filters/FilterFactory.fwd.hh
/// @brief  Forward declaration of Factory class for Filters
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

#ifndef INCLUDED_protocols_moves_FilterFactory_FWD_HH
#define INCLUDED_protocols_moves_FilterFactory_FWD_HH

#include <utility/pointer/owning_ptr.hh>

namespace protocols {
namespace filters {

class FilterFactory;

typedef utility::pointer::owning_ptr< FilterFactory > FilterFactoryOP;
typedef utility::pointer::owning_ptr< FilterFactory const > FilterFactoryCOP;

} //namespace filters
} //namespace protocols

#endif
