// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// Copyright in the Rosetta software belongs to the developers and their institutions.
// For more information, see www.rosettacommons.org.

/// @file ./src/protocols/fldgsn/BetaAlphaBetaMotif.hh
/// @brief
/// @author Nobuyasu Koga ( nobuyasu@uw.edu )

#ifndef INCLUDED_protocols_topology_BetaAlphaBetaMotif_HH
#define INCLUDED_protocols_topology_BetaAlphaBetaMotif_HH

// unit headers
#include <protocols/fldsgn/topology/BetaAlphaBetaMotif.fwd.hh>

// project headers
#include <core/types.hh>
#include <protocols/fldsgn/topology/Sheet.fwd.hh>
#include <protocols/fldsgn/topology/SS_Info2.fwd.hh>

// utility headers
#include <utility/pointer/ReferenceCount.hh>

// C++ headers
#include <cassert>

//Auto Headers
#include <utility/vector1_bool.hh>


namespace protocols {
namespace fldsgn {
namespace topology {

class BetaAlphaBetaMotif : public utility::pointer::ReferenceCount {
public:


  typedef core::Size Size;
	typedef core::Real Real;
	typedef std::string String;
	typedef protocols::fldsgn::topology::SS_Info2_OP SS_Info2_OP;


public:// construct/destruct


	/// @brief default constructor
	BetaAlphaBetaMotif();

	/// @brief value constructor
	BetaAlphaBetaMotif(
    Size const & strand1,
		Size const & strand2,
		Size const & helix,
		Size const & cross_over );

	/// @brief copy constructor
	BetaAlphaBetaMotif( BetaAlphaBetaMotif const & s );

	/// @brief destructor
	~BetaAlphaBetaMotif();


public:// operator


	/// @brief IO Operator
	friend std::ostream & operator<<(std::ostream & out, const BetaAlphaBetaMotif & s );


public:// accessor


	inline Size helix() const { return helix_;	}

	inline Size strand1() const { return strand1_;	}

	inline Size strand2() const { return strand2_;	}

	inline Size cross_over() const {	return cross_over_;	}

	inline bool is_lefthanded() const { return left_handed_;	}

	inline Real hs_dist() const { return hs_dist_; }

	inline Real hs_angle1() const { return hs_angle1_; }

	inline Real hs_angle2() const { return hs_angle2_; }


private:// mutator


	inline void left_handed( bool const v ) { left_handed_ = v; }


public:


	void calc_geometry( SS_Info2_OP const & ssinfo );


private: /// data

	/// @brief
	Size strand1_;

	/// @brief
	Size strand2_;

	/// @brief
	Size helix_;

	/// @brief
	Size cross_over_;

	/// @brief is this left handed ?
	bool left_handed_;

	/// @brief
	Real hs_dist_;

	/// @brief
	Real hs_angle1_;

	/// @brief
	Real hs_angle2_;

};

////////////////////////////////////////////////////////////////////////////////////////////////////
class BetaAlphaBetaMotifSet : public utility::pointer::ReferenceCount {
public:


	typedef core::Real Real;
	typedef core::Size Size;
	typedef protocols::fldsgn::topology::SheetSetOP SheetSetOP;
	typedef protocols::fldsgn::topology::SS_Info2_OP SS_Info2_OP;


public:// constructor/destructor


	/// @brief default constructor
	BetaAlphaBetaMotifSet();

	/// @brief value constructor
	BetaAlphaBetaMotifSet( BetaAlphaBetaMotifs const & bab_motifs );

	/// @brief value constructor
	BetaAlphaBetaMotifSet( SS_Info2_OP const & ssinfo, SheetSetOP const & sheet_set );

	/// @brief copy constructor
	BetaAlphaBetaMotifSet( BetaAlphaBetaMotifSet const & s );

	/// @brief destructor
	~BetaAlphaBetaMotifSet();


public://


	/// @brief
	void push_back( BetaAlphaBetaMotifOP const & bop );

	/// @brief
	void clear();


public:// accessor


	/// @brief
	BetaAlphaBetaMotifs const &	bab_motifs() const;

	/// @brief
	BetaAlphaBetaMotifOP const & bab_motif( Size const & i ) const;

	/// @brief
	friend	std::ostream & operator<<( std::ostream & out, const BetaAlphaBetaMotifSet & s );


public:


	/// @brief
	void calc_geometry( SS_Info2_OP const & ssinfo );


public:


	/// @brief
	void set_babmotifs( SS_Info2_OP const & ssinfo,  SheetSetOP const & sheet_set );


private:

	BetaAlphaBetaMotifs bab_motifs_;

};

} // namespace topology
} // namespace fldsgn
} // namespace protocols

#endif
