// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// Copyright in the Rosetta software belongs to the developers and their institutions.
// For more information, see www.rosettacommons.org.

/// @file ./src/protocols/fldsgn/topology/HSSTriplet.hh
/// @brief
/// @author Nobuyasu Koga ( nobuyasu@u.washington.edu )

#ifndef INCLUDED_protocols_fldsgn_topology_HSSTriplet_HH
#define INCLUDED_protocols_fldsgn_topology_HSSTriplet_HH

// Unit headers
#include <protocols/fldsgn/topology/HSSTriplet.fwd.hh>
#include <protocols/fldsgn/topology/SS_Info2.fwd.hh>

// Project headers
#include <core/types.hh>

//Auto Headers
#include <utility/pointer/ReferenceCount.hh>
#include <map>

namespace protocols {
namespace fldsgn {
namespace topology {

class HSSTriplet : public utility::pointer::ReferenceCount {
public:


	typedef core::Size Size;
	typedef core::Real Real;
	typedef std::string String;
	typedef protocols::fldsgn::topology::SS_Info2_OP SS_Info2_OP;


public:


	/// @brief default constructor
	HSSTriplet():
		helix_( 0 ),
		strand1_( 0 ),
		strand2_( 0 )
	{}

	/// @brief value constructor
	HSSTriplet(
		Size const h,
		Size const s1,
		Size const s2
	):
		helix_( h ),
		strand1_( s1 ),
		strand2_( s2 )
	{}

	/// @brief value constructor
	HSSTriplet( String const & hss );

	/// @brief default destructor
	~HSSTriplet() {}

	/// @brief copy constructor
	HSSTriplet( HSSTriplet const & hss );


	/// @brief operator ==
	inline
	bool operator ==( HSSTriplet const & rval ) const {
		return ( helix_ == rval.helix_ && strand1_ == rval.strand1_ && strand2_ == rval.strand2_ );
	}


public:


	/// @brief IO Operator
	friend std::ostream & operator<<(std::ostream & out, const HSSTriplet & s );


public:

	inline
	Size helix() const
	{
		return helix_;
	}

	inline
	Size strand1() const
	{
		return strand1_;
	}

	inline
	Size strand2() const
	{
		return strand2_;
	}

	Size calc_inout( SS_Info2_OP const & ssinfo ) const;

private:


	/// @brief helix
	Size helix_;

	/// @brief strand1
	Size strand1_;

	/// @brief strand2
	Size strand2_;


}; // HSSTriplet


class HSSTripletSet : public utility::pointer::ReferenceCount {
public:


	typedef core::Size Size;
	typedef std::string String;


public:


	/// @brief default constructor
	HSSTripletSet();

	/// @brief value constructor
	HSSTripletSet( HSSTriplets const & s );

	/// @brief value constructor
	HSSTripletSet( String const & s );

	/// @brief copy constructor
	HSSTripletSet( HSSTripletSet const & s );

	/// @brief destructor
	~HSSTripletSet();


public:// operator


	/// @brief IO Operator
	friend std::ostream & operator<<(std::ostream & out, const HSSTripletSet & s );


public: //accessor


	/// @brief
	void push_back( HSSTripletOP const & hssop );

	/// @brief
	void clear();


public: //accessor


	/// @brief
	HSSTripletOP const & hss_triplet( Size const helix );


	/// @brief
	HSSTriplets const & hss_triplets() const;


private: //data



	HSSTriplets hss_triplets_;


	std::map< Size, HSSTripletOP > helix2hss_;


}; // HSSTripletSet

} // namespace topology
} // namespace fldsgn
} // namespace protocols

#endif
