// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet;
//
// (C) 199x-2008 Hebrew University, Jerusalem
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
/// @file   FlexPepDockingFlags.fwd.hh
///
/// @brief flags structure for FlexPepDocking protocols - forward declarations
/// @date January 1, 2009
/// @author Barak Raveh

#ifndef INCLUDED_protocols_flexPepDocking_FlexPepDockingFlags_FWD_HH
#define INCLUDED_protocols_flexPepDocking_FlexPepDockingFlags_FWD_HH

#include <utility/pointer/access_ptr.hh>
#include <utility/pointer/owning_ptr.hh>

namespace protocols {
namespace flexpep_docking {

class FlexPepDockingFlags;
typedef utility::pointer::access_ptr< FlexPepDockingFlags > FlexPepDockingFlagsAP;
typedef utility::pointer::access_ptr< FlexPepDockingFlags const > FlexPepDockingFlagsCAP;
typedef utility::pointer::owning_ptr< FlexPepDockingFlags > FlexPepDockingFlagsOP;
typedef utility::pointer::owning_ptr< FlexPepDockingFlags const > FlexPepDockingFlagsCOP;

} // namespace flexpep_docking
} // namespace protocols

#endif

