// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/parser/DataLoader.cc
/// @brief  Implementation of the XML parser's DataLoader base class (ctor & dstor)
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

// Unit Headers
#include <protocols/jd2/parser/TaskOperationLoader.hh>
#include <protocols/jd2/parser/StandardLoaderCreators.hh>

// Project Headers
#include <core/pack/task/operation/TaskOperation.hh>
#include <core/pack/task/operation/TaskOperationFactory.hh>
#include <core/util/Tracer.hh>

// Utility headers
#include <utility/Tag/Tag.hh>

namespace protocols {
namespace jd2 {
namespace parser {

static core::util::Tracer TR( "protocols.jd2.parser.TaskOperationLoader" );

TaskOperationLoader::TaskOperationLoader() {}
TaskOperationLoader::~TaskOperationLoader() {}

void TaskOperationLoader::load_data(
	core::pose::Pose const &,
	utility::Tag::TagPtr const tag,
	moves::DataMap & data
) const
{
	using namespace core::pack::task::operation;
	typedef utility::vector0< utility::Tag::TagPtr > TagPtrs;

	TagPtrs const TO_tags( tag->getTags() );

	for( TagPtrs::const_iterator tp( TO_tags.begin() ), tp_e( TO_tags.end() ); tp != tp_e; ++tp ) {
		std::string const type( (*tp)->getName() );
		if ( ! (*tp)->hasOption("name") ) {
			utility_exit_with_message( "Can't create unnamed TaskOperation (type: " + type + ")" );
		}
		std::string const name( (*tp)->getOption<std::string>("name") );
		if ( data.has( "task_operations", name ) ) {
			TR << "WARNING WARNING TaskOperation of name \"" << name
				<< "\" (with type " << type << ") already exists. Skipping\n" << tag << std::endl;
			continue;
		}
		TaskOperationOP new_t_o( TaskOperationFactory::get_instance()->newTaskOperation( type, *tp ) );
		runtime_assert( new_t_o );
		data.add("task_operations", name, new_t_o );
		TR << "Defined TaskOperation named \"" << name << "\" of type " << type << std::endl;
	}
	TR.flush();
}

DataLoaderOP
TaskOperationLoaderCreator::create_loader() const { return new TaskOperationLoader; }

std::string
TaskOperationLoaderCreator::keyname() const { return "TASKOPERATIONS"; }


} //namespace parser
} //namespace jd2
} //namespace protocols
