// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @brief
/// @detailed
///
///
///
/// @author Oliver Lange

// Unit Headers
#include <protocols/jumping/PairingsList.hh>

// Package Headers

// Project Headers

// ObjexxFCL Headers
#include <ObjexxFCL/format.hh>
#include <ObjexxFCL/FArray1A.hh>


// Utility headers
#include <utility/vector1.fwd.hh>
#include <utility/io/izstream.hh>
#include <utility/exit.hh>

#include <core/util/Tracer.hh>

// #include <core/options/option.hh>
// #include <core/options/keys/OptionKeys.hh>

// numeric headers
// #include <numeric/random/random.hh>

//// C++ headers
// AUTO-REMOVED #include <cstdlib>
#include <string>

static core::util::Tracer tr("protocols.jumping");

using core::Real;
using namespace core;
using namespace util;
using namespace ObjexxFCL;
//using namespace core::options;

namespace protocols {
namespace jumping {

Pairing::Pairing( ObjexxFCL::FArray1A_int data) {
	pos1        = data(1);
	pos2        = data(2);
	orientation = data(3);
	pleating    = data(4);
}

Pairing
Pairing::reverse() {
	Size tmp = pos2;
	pos2 = pos1;
	pos1 = tmp;

	if ( orientation == PARALLEL ) { // flip pleating
		if ( pleating == 1 ) {
			pleating = 2;
		} else if ( pleating == 2 ) {
			pleating = 1;
		} else {
			std::cout << "unrecognized pleating:" << fmt::SS( pleating ) << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}
	return *this;
}

Pairing
Pairing::generate_reversed() const {
	Pairing p(*this);
	p.reverse();
	return p;
}
//static numeric::random::RandomGenerator RG(132238);  // <- Magic number, do not change it, huaah hah ha!
void read_pairing_list( std::string pairing_file, PairingsList& pairings)
{
  	utility::io::izstream pairing_stream( pairing_file );
  if ( !pairing_stream ) {
    tr.Fatal << "can't open pairings file!!!" << pairing_file << std::endl;
    pairing_stream.close();
    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
	read_pairing_list( pairing_stream, pairings );
  pairing_stream.close();
}

void read_pairing_list( std::istream& pairing_stream, PairingsList& pairings) {
  std::string line;
	Size a,b,c,d;
  while ( getline( pairing_stream, line ) ) {
    std::istringstream line_stream( line );
    // a=i, b=j, c=orientation(1 or 2), d=pleating(1 or 2)
    std::string o, pleat;
    line_stream >> a >> b >> o >> pleat;
    if ( line_stream.fail() || o.size() != 1 ) {
      std::cout << "[ERROR] unable to parse " << line << std::endl;
      continue;
    }

    if ( o == "A" || o == "1" ) {
      c = 1;
    } else if ( o == "P" || o == "2") {
      c = 2;
    } else if ( o == "X" ) {
			c = 0;
		} else {
      std::cout << "bad orientation: " << o << std::endl;
      continue;
    }

		if ( pleat == "O" || pleat== "1" ) {
			d = 1;
		} else if ( pleat == "I" || pleat == "2" ) {
			d = 2;
		} else if ( pleat == "X" ) {
			d = 0;
		} else {
			std::cout << "bad pleating: " << pleat << std::endl;
		}

    if ( ( a < 1 || b < 1 ) || ( a == b ) || ( c != 1 && c != 2 && c != 0 ) ||
      ( d != 1 && d != 2 && d != 0 ) ) {
      std::cout << "bad pairing:" <<
				fmt::SS( a ) << fmt::SS( b ) << fmt::SS( c ) << fmt::SS( d ) << std::endl;
      utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
    }

		Pairing p( a, b, c, d);
    if ( a > b ) p.reverse();
    pairings.push_back( p );

  }
} // read_pairings

std::ostream& operator<< ( std::ostream& out, Pairing const& p) {
	out << fmt::RJ(5, p.pos1 ) << fmt::RJ(5, p.pos2 ) << " "
			<< ( p.orientation ? ( p.is_parallel() ? "P" : "A") : "X" ) << " "
			<< ( p.pleating ? ( p.is_inwards() ? "I" : "O" ) : "X" );
	return out;
}

std::ostream& operator<< ( std::ostream& out, PairingsList const& p) {
	for (PairingsList::const_iterator it= p.begin(),
				 eit = p.end(); it!=eit; ++it ) {
		out << (*it) << "\n";
	}
	return out;
}

bool has_orientation_and_pleating( PairingsList const& pairings ) {
	for ( PairingsList::const_iterator it = pairings.begin(), eit = pairings.end();
				it != eit; ++it ) {
		if ( it->orientation == 0 || it->pleating == 0 ) return false;
	}
	return true;
}

} // jumping
} // protocols
