// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_HighResDocking_HH
#define INCLUDED_protocols_ligand_docking_HighResDocking_HH

// Unit Headers
#include <protocols/ligand_docking/HighResDocker.fwd.hh>
#include <protocols/ligand_docking/ligand_options/Interface.fwd.hh>
#include <protocols/ligand_docking/MinimizeLigand.fwd.hh>
#include <protocols/ligand_docking/MinimizeBackbone.hh>
#include <protocols/ligand_docking/MoveMapBuilder.fwd.hh>

// Package Headers
#include <core/pose/Pose.fwd.hh>
#include <protocols/ligand_docking/ResidueTorsionRestraints.fwd.hh>
#include <core/kinematics/MoveMap.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <protocols/moves/Mover.hh>

// Project Headers
#include <core/types.hh>

//// Scripter Headers
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>

// Utility Headers

// STL Headers
#include <map>
#include <string>
#include <set>
#include <vector>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {

class HighResDocker: public protocols::moves::Mover
{
public:
	enum protocol_enum {
		meiler2006,
		abbreviated,
		abbrev2,
		min_only,
		custom
	};

	HighResDocker();
	virtual ~HighResDocker();
	HighResDocker(HighResDocker const & that);

	virtual protocols::moves::MoverOP clone() const;
	virtual protocols::moves::MoverOP fresh_instance() const;
	virtual std::string get_name() const;

	void parse_my_tag(
		utility::Tag::TagPtr const tag,
		protocols::moves::DataMap &,
		protocols::filters::Filters_map const &,
		protocols::moves::Movers_map const &,
		core::pose::Pose const &
	);

	void apply(core::pose::Pose & pose);

private:
	core::Size num_cycles_;
	core::Size repack_every_Nth_;
	std::map< std::string, protocol_enum > enum_map_;

	std::vector<std::string> chains_;
	core::scoring::ScoreFunctionOP score_fxn_;
	MinimizeLigandOPs minimize_ligands_;
	MoveMapBuilderOP movemap_builder_;

	void set_cycles(
		protocol_enum const p,
		utility::Tag::TagPtr const tag
	);

	void enable_ligand_rotamer_packing(
		core::pose::Pose const & pose,
		core::Size const ligand_residue_id,
		core::pack::task::PackerTaskOP & pack_task
	) const;

	core::pack::task::PackerTaskOP
	make_packer_task(
			core::pose::Pose const & pose,
			bool all_residues= false
	) const;

	core::pack::task::PackerTaskOP
	make_packer_task_from_vector(
			core::pose::Pose const & pose,
			ligand_options::Interface const allow_repack
	) const;

	utility::vector1<protocols::moves::MoverOP>
	create_rigid_body_movers(core::pose::Pose const & pose) const;

	void apply_rigid_body_moves(
		core::pose::Pose & pose,
		utility::vector1<protocols::moves::MoverOP> & rigid_body_movers
	);
};

//void setup_native_residue_favoring(core::pose::Pose & pose, core::pack::task::PackerTaskOP task);

} //namespace ligand_docking
} //namespace protocols

#endif
