// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/IfMover.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_IfMover_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_IfMover_HH

#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>

namespace protocols {
namespace moves {

/// @brief performs an IF( filter->apply( pose ) ) THEN mover->apply( pose )
class IfMover : public protocols::moves::Mover
{
public:
	IfMover() : protocols::moves::Mover( "If" ) {}
	protocols::moves::MoverOP clone() const {
		return protocols::moves::MoverOP( new IfMover( *this ) );
	}
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new IfMover ); }
	void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~IfMover() {};
private:
	protocols::moves::MoverOP mover_;
	protocols::filters::FilterOP filter_;
};

} // moves
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_IfMover_HH*/
