// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/moves/MetropolisHastingsMover.fwd.hh
/// @brief  MetropolisHastingsMover forward declarations header
/// @author

#ifndef INCLUDED_protocols_moves_MetropolisHastingsMover_FWD_HH
#define INCLUDED_protocols_moves_MetropolisHastingsMover_FWD_HH

// Utility headers
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/access_ptr.hh>

namespace protocols {
namespace moves {

//Forwards and OP typedefs
class MetropolisHastingsMover;
typedef utility::pointer::owning_ptr< MetropolisHastingsMover > MetropolisHastingsMoverOP;
typedef utility::pointer::owning_ptr< MetropolisHastingsMover const > MetropolisHastingsMoverCOP;
typedef utility::pointer::access_ptr< MetropolisHastingsMover > MetropolisHastingsMoverAP;
typedef utility::pointer::access_ptr< MetropolisHastingsMover const > MetropolisHastingsMoverCAP;

} //moves
} //protocols

#endif //INCLUDED_protocols_moves_MetropolisHastingsMover_FWD_HH
