// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   src/protocols/moves/MinPackMover.hh
/// @brief  Mover class to invoke core::pack::min_pack
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

#ifndef INCLUDED_protocols_moves_MinPackMover_HH
#define INCLUDED_protocols_moves_MinPackMover_HH

// Unit headers
#include <protocols/moves/MinPackMover.fwd.hh>
#include <protocols/moves/Mover.hh>

// Project headers
#include <core/pack/task/PackerTask.fwd.hh>

#ifdef __clang__
#include <core/pack/task/PackerTask.hh>
#endif

#include <core/pack/task/TaskFactory.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>

#include <utility/Tag/Tag.fwd.hh>
#include <utility/vector0.hh>
#include <utility/vector1.hh>



namespace protocols {
namespace moves {

/// @brief a mover that packs and minimizes the side-chains.  It uses
/// a ScoreFunction for packing and either a PackerTask, or a TaskFactory that generates
/// a PackerTask for instructions on what rotamer sets are allowed at each residue
/// position during packing.
class MinPackMover : public Mover {
public:
	typedef core::pack::task::PackerTaskCOP PackerTaskCOP;
	typedef core::pack::task::TaskFactoryCOP TaskFactoryCOP;
	typedef core::scoring::ScoreFunctionCOP ScoreFunctionCOP;

public:
	///@brief default constructor
	MinPackMover();

	///@brief constructor with typename
	MinPackMover( std::string const & );

	MinPackMover(
		ScoreFunctionCOP scorefxn
	);
	MinPackMover(
		ScoreFunctionCOP scorefxn,
		PackerTaskCOP task
	);

	// destructor (important for properly forward-declaring smart-pointer members)
	virtual ~MinPackMover();

	// copy constructor
	MinPackMover( MinPackMover const & other );

	// methods
	virtual void apply( Pose & pose );
	virtual std::string get_name() const;
	bool task_is_valid( Pose const & pose ) const; // should this be virtual?

	///@brief parse XML (specifically in the context of the parser/scripting scheme)
	virtual void parse_my_tag(
		TagPtr const,
		DataMap &,
		Filters_map const &,
		Movers_map const &,
		Pose const & );

	///@brief parse "scorefxn" XML option (can be employed virtually by derived Packing movers)
	virtual void parse_score_function(
		TagPtr const,
		DataMap const &,
		Filters_map const &,
		Movers_map const &,
		Pose const & );

	///@brief parse "task_operations" XML option (can be employed virtually by derived Packing movers)
	virtual void parse_task_operations(
		TagPtr const,
		DataMap const &,
		Filters_map const &,
		Movers_map const &,
		Pose const & );

	///@brief required in the context of the parser/scripting scheme
	virtual MoverOP fresh_instance() const;

	///@brief required in the context of the parser/scripting scheme
	virtual MoverOP clone() const;

	// setters
	void score_function( ScoreFunctionCOP sf );
	void task_factory( TaskFactoryCOP tf );
	void task( PackerTaskCOP t );
	void nloop( core::Size nloop_in );


	// accessors
	ScoreFunctionCOP score_function() const;
	PackerTaskCOP task() const;
	TaskFactoryCOP task_factory() const;


private:
	// pointers to data that are passed in
	ScoreFunctionCOP scorefxn_;
	PackerTaskCOP task_;
	TaskFactoryCOP task_factory_;

};


} // moves
} // protocols

#endif
