// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/moves/RotamerRecoveryMover.hh
/// @brief A wrapper that measures how similar the rotamers are between before and after running the child mover
/// @author Matthew O'Meara (mattjomeara@gmail.com)
/// @author P. Douglas Renfrew

#ifndef INCLUDED_protocols_moves_RotamerRecoverMover_HH
#define INCLUDED_protocols_moves_RotamerRecoverMover_HH

// Unit Headers
#include <protocols/moves/RotamerRecoveryMover.fwd.hh>
#include <protocols/moves/Mover.hh>

// program Headers
#include <protocols/rotamer_recovery/RotamerRecovery.hh>

// Project Headers
#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/pack/task/TaskFactory.hh>
#include <core/scoring/ScoreFunction.hh>

// Utility Headers
#include <utility/Tag/Tag.fwd.hh>

// C++ Headers
#include <string>

namespace protocols {
namespace moves {

class RotamerRecoveryMover : public Mover {
public: // type definitions

public: // constructors destructors

	/// @brief default constructor
	RotamerRecoveryMover();


	RotamerRecoveryMover(
		std::string const & reporter,
		std::string const & output_fname,
		std::string const & comparer,
		core::scoring::ScoreFunctionOP scfxn,
		core::pack::task::TaskFactoryOP task_factory);

	~RotamerRecoveryMover();

	RotamerRecoveryMover( RotamerRecoveryMover const & src);

public: // functional interface

	virtual
	void
	register_options() const ;

	virtual
	void
	apply( core::pose::Pose & pose );

	virtual
	std::string
	get_name() const;

	/// @brief make a copy
	virtual MoverOP clone() const;

	/// @brief make a copy but use default constructor
	virtual MoverOP fresh_instance() const;

	virtual
	void
	parse_my_tag(
		TagPtr const /*tag*/,
		DataMap & /*data*/,
		Filters_map const & /*filters*/,
		Movers_map const & movers,
		Pose const &);

	///@brief this function informs the job distributor (august 08
	///vintage) whether this object needs to be regenerated when the
	///input pose is about to change (for example, if the mover has
	///special code on the first apply() that is only valid for that
	///one input pose).
	virtual
	bool
	reinitialize_for_new_input() const;

	virtual
	core::scoring::ScoreFunctionOP
	get_scorefunction();

	virtual
	void
	set_scorefunction(
		core::scoring::ScoreFunctionOP);

private: // data

	rotamer_recovery::RotamerRecoveryOP rotamer_recovery_;
	core::scoring::ScoreFunctionOP scfxn_;
	core::pack::task::TaskFactoryOP task_factory_;

};

} // namespace moves
} // namespace protocols

#endif
