// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/ligand_docking/qsar/qsarTypeManager.hh
/// @author Sam DeLuca

#ifndef INCLUDED_protocols_qsar_qsarTypeManager_HH_
#define INCLUDED_protocols_qsar_qsarTypeManager_HH_

#include <protocols/qsar/qsarTypeManager.fwd.hh>
#include <map>
#include <string>
#include <utility/vector1.hh>
#include <string>

namespace protocols {
namespace qsar {

class qsarTypeManager {
public:
	/// @brief get a qsarType enum value from a string
	static qsarType qsar_type_from_name(std::string const & name);
	/// @brief get a string from a qsarType enum
	static std::string name_from_qsar_type(qsarType const & qsar_type);
	/// @brief check to see if a string is a valid qsarType
	static bool is_qsar_type(std::string const & name);
private:

	static void setup_qsar_type_names();

	static bool initialized_;
	static std::map<std::string, qsarType> name2qsar_type_;
	static utility::vector1<std::string> qsar_type2name_;
};


}
}


#endif /* QSARTYPEMANAGER_HH_ */
