// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/toolbox/TaskOperations/ThreadSequenceOperation.cc
/// @brief
/// @author Sarelf Fleishman sarelf@uw.edu

// Unit Headers
#include <protocols/toolbox/TaskOperations/ThreadSequenceOperation.hh>
#include <protocols/toolbox/TaskOperations/ThreadSequenceOperationCreator.hh>

// Project Headers
#include <core/pose/Pose.hh>

#include <core/pack/task/PackerTask.hh>
#include <core/pack/task/operation/TaskOperations.hh>

// Utility Headers
#include <core/types.hh>
#include <core/util/Tracer.hh>
#include <utility/vector1.hh>
#include <utility/Tag/Tag.hh>
#include <core/pack/task/operation/ResLvlTaskOperations.hh>
#include <core/pack/task/operation/TaskOperations.hh>

using core::util::Error;
using core::util::Warning;
static core::util::Tracer TR( "protocols.toolbox.TaskOperations.ThreadSequenceOperation" );

namespace protocols {
namespace toolbox {
namespace TaskOperations {

using namespace core::pack::task::operation;
using namespace std;

ThreadSequenceOperation::ThreadSequenceOperation() : parent()
{
	target_sequence( "" );
}

ThreadSequenceOperation::ThreadSequenceOperation( std::string const seq ) : parent()
{
	target_sequence( seq );
}

ThreadSequenceOperation::~ThreadSequenceOperation() {}

core::pack::task::operation::TaskOperationOP
ThreadSequenceOperationCreator::create_task_operation() const
{
	return new ThreadSequenceOperation;
}

core::pack::task::operation::TaskOperationOP ThreadSequenceOperation::clone() const
{
	return new ThreadSequenceOperation( *this );
}

void
ThreadSequenceOperation::apply( core::pose::Pose const & pose, core::pack::task::PackerTask & task ) const
{
	using core::pack::task::operation::RestrictAbsentCanonicalAAS;
	using namespace core::chemical;

	runtime_assert( target_sequence().length() == pose.total_residue() );
	for( core::Size resi( 1 ); resi<=pose.total_residue(); ++resi ){
		RestrictAbsentCanonicalAAS racaas;
		utility::vector1< bool > keep_aas( num_canonical_aas, false );
		keep_aas[ aa_from_oneletter_code( target_sequence()[ resi-1 ] ) ] = true;
		racaas.keep_aas( keep_aas );
		racaas.include_residue( resi );
		racaas.apply( pose, task );
	}
}

void
ThreadSequenceOperation::target_sequence( std::string const seq )
{
	target_sequence_ = seq;
}

std::string
ThreadSequenceOperation::target_sequence() const
{
	return( target_sequence_ );
}

void
ThreadSequenceOperation::parse_tag( TagPtr tag )
{
	target_sequence( tag->getOption< std::string >( "target_sequence" ) );
	TR<<"Threading with sequence: "<<target_sequence()<<std::endl;
}

} //namespace protocols
} //namespace toolbox
} //namespace TaskOperations
