#!/usr/bin/python

## (c) Copyright Rosetta Commons Member Institutions.
## (c) This file is part of the Rosetta software suite and is made available under license.
## (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
## (c) For more information, see http://www.rosettacommons.org. Questions about this can be
## (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
##
## Authors: Mike Tyka

import sys
import os
import string

non_numerical_cols = [
"aln_id",
"user_tag",
"description"
];

if len(sys.argv) < 2:
	print "Syntax: %s <silentfile> <columnname1> [	<columnname2> ... ]"%sys.argv[0]
	sys.exit(0)

file = open(sys.argv[1],"r")

lines = string.split(file.read(),"\n")

showfilename = False;

names = []
for arg in sys.argv[2:]:
	if arg == "-f":
		showfilename = True
		continue
	names.append((arg,-1))

donetitles = False

for (i,(n,j)) in enumerate(names):
	names[i] = (string.lower(n), j)

if len(names)<=0:
	sys.stderr.write("Warning: no columns names supplied: defaulting to rms vs score\n")
	names.append( ("rms", -1) )
	names.append( ("score", -1) )


for number,l in enumerate(lines):
	token = string.split(l)
	if len(token) <= 0: continue
	## SCORE LINE HEADERS
	if not donetitles:
	 if (token[0] == "SCORE ") or (token[0] == "SCORE:") :
		## look for names

		for ti,t in enumerate(token):
			for (i,(n,j)) in enumerate(names):
				if string.lower(t) == n:	## if names match
					(existing_n, existing_ti) = names[i];
					if( existing_ti < 0):
						names[i] = (n,ti)	## remember index


		Error = False
		for i,(n,j) in enumerate(names):
			if j < 0:
				sys.stderr.write("Error: Cannot find column named '%s' \n"%n)
				Error = True

		if Error: sys.exit(1)
		donetitles = True
		continue


	## SCORE LINE
	if token[0] == "SCORE:":
		token = string.split(l)
		brokenline = False
		for (n,i) in names:
			if i >= len( token ):
				brokenline = True
				continue
		if brokenline : continue
		if showfilename: sys.stdout.write("%s "%sys.argv[1])


		for (n,i) in names:
			is_nonnumtag = False
			for nonnumtags in non_numerical_cols:
	 			if n == nonnumtags:
					is_nonnumtag = True
					break
			if is_nonnumtag: break

			## now check if the token is numerical.

			try:
				t = float( token[i] )
			except:
				brokenline = True;

		if brokenline : continue
		for (n,i) in names:
			sys.stdout.write("%10s "%token[i])
		sys.stdout.write("\n")
