// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file rosetta_design_wizard.hh
/// @brief Control Rosetta Design Wizard's Mini backend
/// @author Matt O'Meara (mattjomeara@gmail.com)

#ifndef INCLUDE_apps_pilot_rosetta_design_wizard
#define INCLUDE_apps_pilot_rosetta_design_wizard
#include <string>
#include <utility>
#include <vector>
#include <core/pack/task/PackerTask.hh>
#include <core/pose/Pose.hh>
#include <core/util/Tracer.hh>

#include <utility/pointer/owning_ptr.hh>



class CaptureTStream : public core::util::otstream
{
public:
	CaptureTStream(){}
	virtual ~CaptureTStream(){}

	std::string read(){
		std::string output( buffer_.str() );
		buffer_.str("");
		return output;
	}

protected:

	void t_flush( std::string const & s ){
		buffer_ << s;
	}

private:
	std::stringstream buffer_;
};

typedef utility::pointer::owning_ptr< CaptureTStream > CaptureTStreamOP;


void    init_mini(          const char * database                       );

int     get_init_state(                                                 );

int     get_init_state_pose( const char * pose_id                       );

std::string get_tracer();

void    set_weights( std::string weights_tag, std::string const & patch_tag );

std::vector< float > get_weights(                                       );

void    init_pose(          const char * pose_id, const char * pdb      );

core::pose::PoseOP locate_pose(   const char * pose_id );

core::pack::task::PackerTaskOP locate_task( const char * pose_id );

char *  get_pdb(            const char * pose_id		    						    );

void    print_score(        const char * pose_id										    );

float   get_score(          const char * pose_id									    	);

char *  get_detailed_score( const char * pose_id									    	);

std::vector< std::string > get_score_terms(                             );

float   get_weighted_score( const char * pose_id,
														char chain,
														int pdb_seqpos,
														const char * scoretype_name                 );

void set_task(      const char * pose_id, const char * resfile  );

void clean_residue_task( const char * pose_id, char chain, int pdb_seqpos);

void set_residue_task( const char * pose_id, char chain, int pdb_seqpos, std::string command_str);

char *  get_task(           const char * pose_id										    );

std::vector< std::pair< char, int > > get_residues( const char * pose_id );

std::vector< bool > get_packable( const char * pose_id                  );

std::vector< int > num_res_types( const char * pose_id                  );

void    run_task(           const char * pose_id										    );



#endif

