// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file apps/benchmark/scientific/rotamer_recovery.cc
/// @brief this determines the percent of rotamers correctly predictied during a repack
/// @author Matthew O'Meara (mattjomeara@gmail.com)



// Unit Headers
#include <protocols/jd2/JobDistributor.hh>
#include <protocols/moves/RotamerRecoveryMover.hh>


// Project Headers
#include <protocols/init.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>
#include <core/options/keys/packing.OptionKeys.gen.hh>
#include <core/options/option_macros.hh>
#include <core/pose/Pose.hh>
#include <core/io/pdb/pose_io.hh>


// Utility Headers
#include <utility/excn/Exceptions.hh>
#include <utility/exit.hh>
#include <utility/file/FileName.hh>

using std::cerr;
using std::cout;
using std::endl;
using protocols::init;
using core::pose::PoseOP;
using core::io::pdb::pose_from_pdb;
using protocols::moves::RotamerRecoveryMover;
using protocols::moves::RotamerRecoveryMoverOP;
using protocols::jd2::JobDistributor;
using utility::excn::EXCN_Base;
using utility::file::FileName;

OPT_2GRP_KEY( File, out, file, rotamer_recovery_results )

void
register_options() {
  using namespace core::options;
  using namespace OptionKeys;
  OPT( in::file::s );
  OPT( in::file::l );
  OPT( in::file::silent );
  OPT( in::file::native );
  OPT( packing::use_input_sc );
	//  NEW_OPT( out::file::rotamer_recovery_results, "Write table containing all residues that do not have the correct rotameric conformation", "rotamer_recover_results.out");
}

int
main( int argc, char * argv [] )
{
  register_options();

  init(argc, argv);

  using namespace core::options;
  using namespace OptionKeys;
	//  FileName results(option[out::file::rotamer_recovery_results].value());
  RotamerRecoveryMoverOP rr( new RotamerRecoveryMover());

  try{
    JobDistributor::get_instance()->go( rr );
  } catch (EXCN_Base & excn ) {
    cerr << "Exception: " << endl;
    excn.show( cerr );
    cout << "Exception: " << endl;
    excn.show( cout ); //so its also seen in a >LOG file
  }

  return 0;

}








