// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @author Phil Bradley


#ifndef INCLUDED_core_conformation_util_HH
#define INCLUDED_core_conformation_util_HH


// Unit headers

// Project headers
#include <core/types.hh>
#include <core/conformation/Residue.fwd.hh>
#include <core/conformation/Conformation.fwd.hh>

#include <core/chemical/ResidueConnection.fwd.hh>

#include <core/kinematics/tree/Atom.fwd.hh>

// Utility headers

// C++ headers
#include <iosfwd>

namespace core {
namespace conformation {

void
orient_residue_for_ideal_bond(
	Residue & moving_rsd,
	chemical::ResidueConnection const & moving_connection,
	Residue const & fixed_rsd,
	chemical::ResidueConnection const & fixed_connection,
	Conformation const & conformation // unused
);

/// @brief  Sets the two bond angles and the bond length across the junction, rebuilds dependent atoms (eg O,H)
void
insert_ideal_bonds_at_polymer_junction(
	Size const seqpos,
	Conformation & conformation
);

void
insert_ideal_mainchain_bonds(
	Size const seqpos,
	Conformation & conformation
);


/// @brief  Idealize backbone and sidechain at seqpos
void
idealize_position(
	Size const seqpos,
	Conformation & conformation
);


/// @brief  Return true if position contains an ideal geometry up to some epsilon
///
/// @params seqpos - sequence position
/// @params conformation - conformation object
/// @params theta_epsilon - permitted deviation from ideal bond angles, in Radians
/// @params D_epsilon - permitted deviation from ideal bond length
///
/// @remarks conformation is needed for context of polymer nbrs
bool
is_ideal_position( // Barak 6/30/09
	Size const seqpos,
	Conformation const& conformation,
 	Real theta_epsilon = 0.005, // ~0.29 degrees
	Real D_epsilon = 0.02
);


/// @brief  Fills coords of target_rsd with coords from source_rsd of same atom_name, rebuilds others.
void
copy_residue_coordinates_and_rebuild_missing_atoms(
	Residue const & source_rsd,
	Residue & target_rsd,
	Conformation const & conf
);


///
void
show_atom_tree( kinematics::tree::Atom const & atom, Conformation const & conf, std::ostream & os );


} // conformation
} // core



#endif
