// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/DiversifyDihedralsSelector.hh
/// @brief provides a selector that picks best fragments based on their total score
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_DiversifyDihedralsSelector_HH
#define INCLUDED_core_fragment_picking_DiversifyDihedralsSelector_HH

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/FragmentSelectingRule.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

#include <core/types.hh>

#include <utility/vector1.hh>

namespace core {
namespace fragment {
namespace picking {

/// @brief selects fragments by running several selectors
class DiversifyDihedralsSelector: public FragmentSelectingRule {
public:

	/// @brief  Constructor sets the desired number of fragments and crmsd cutoff.
	DiversifyDihedralsSelector(Size frags_per_pos,Real cutoff) : FragmentSelectingRule(frags_per_pos) {
		cutoff_ = cutoff;
	}

	/// @brief  Selects desired number of fragments from a given set of candidates
	virtual void select_fragments(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >&,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >&);

	virtual ~DiversifyDihedralsSelector() {
	}

	Real dihedral_rmsd(FragmentCandidateOP,FragmentCandidateOP);

private:
	Real cutoff_;
	utility::vector1<core::Real> phi_;
	utility::vector1<core::Real> psi_;
};

} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_DiversifyDihedralsSelector_HH */
