// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/FragmentComparatorBase.hh
/// @brief defines a base class for all fragment comparators
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_FragmentComparatorBase_HH
#define INCLUDED_core_fragment_picking_FragmentComparatorBase_HH

// package headers
#include <core/fragment/picking/FragmentComparatorBase.fwd.hh>
#include <core/fragment/picking/FragmentCandidate.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

namespace core {
namespace fragment {
namespace picking {

class FragmentComparatorBase : public utility::pointer::ReferenceCount {
public:
    virtual bool operator()(
            std::pair<FragmentCandidateOP, scores::FragmentScoreMapOP> first_candidate,
	    std::pair<FragmentCandidateOP, scores::FragmentScoreMapOP> second_candidate) = 0;
};

} // picking
} // fragment
} // core

#endif
