// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file   core/fragment/picking/TorsionBinIO.hh
/// @brief reader for a probability distribution over A,B,E,G,O torsion bins.
/// @author James Thompson

#ifndef INCLUDED_core_fragment_picking_TorsionBinIO_HH
#define INCLUDED_core_fragment_picking_TorsionBinIO_HH

// Package headers
#include <core/types.hh>

/// C++ headers
// AUTO-REMOVED #include <string>

// utility headers
// AUTO-REMOVED #include <utility/vector1.hh>
#include <iostream>

//Auto Headers
#include <utility/vector1_bool.hh>


namespace core {
namespace fragment {
namespace picking {

class TorsionBinIO {
public:

	TorsionBinIO();

	void read( std::istream & input );
	void write( std::ostream & output );

	utility::vector1< core::Real > const & prof_row( Size const idx ) const;

	utility::vector1< utility::vector1< core::Real > > const & matrix() const;

	Size nrows() const;

private:
	std::string sequence_;
	utility::vector1< utility::vector1< core::Real > > probs_;
	utility::vector1< char > bin_names_;
}; // TorsionBinIO

} // picking
} // fragment
} // core

#endif /* INCLUDED_core_fragment_picking_TorsionBinIO_HH */
